<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }
        .invoice-container {
            width: 900px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #007bff;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .invoice-header .company-details {
            text-align: right;
        }
        .invoice-header .company-details h2 {
            margin: 0;
            font-size: 24px;
        }
        .invoice-header .company-details p {
            margin: 2px 0;
            font-size: 14px;
        }
        .invoice-header img {
            max-width: 150px;
        }
        .invoice-title {
            text-align: right;
        }
        .invoice-title h1 {
            font-size: 32px;
            color: #007bff;
            margin: 0;
        }
        .invoice-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        .invoice-info .left, .invoice-info .right {
            width: 45%;
        }
        .invoice-info p {
            margin: 4px 0;
            font-size: 14px;
        }
        .address-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        .address-section .bill-to,
        .address-section .ship-to {
            width: 48%;
            border: 1px solid #007bff;
            border-radius: 5px;
            padding: 10px;
        }
        .address-section h4 {
            margin: 0 0 10px;
            font-size: 16px;
            background-color: #007bff;
            color: #fff;
            padding: 5px;
            border-radius: 3px;
        }
        .item-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }
        .item-table th, .item-table td {
            padding: 10px;
            text-align: left;
            border: 1px solid #dee2e6;
        }
        .item-table th {
            background-color: #007bff;
            color: #fff;
        }
        .totals-section {
            width: 500px;
            margin-left: auto;
            margin-top: 20px;
            border-collapse: collapse;
        }
        .totals-section th, .totals-section td {
            padding: 10px;
            text-align: right;
            border: 1px solid #dee2e6;
        }
        .totals-section th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .totals-section td {
            background-color: #fff;
        }
        .notes-section {
            margin-top: 20px;
        }
        .notes-section h5 {
            background-color: #007bff;
            color: #fff;
            padding: 5px;
            border-radius: 3px;
            margin-bottom: 10px;
        }
        .notes-section p {
            border: 1px solid #dee2e6;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
        }
        .footer-section {
            text-align: center;
            margin-top: 30px;
            font-size: 14px;
            color: #888;
        }
        @media print {
            .btn-print {
                display: none;
            }
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="invoice-container">
    <div class="invoice-header">
        <div class="company-logo">
            <img src="logo.png" alt="Company Logo">
        </div>
        <div class="company-details">
            <h2>Janaka Tealors</h2>
            <p>Peradeniya Rd, Kandy</p>
        </div>
    </div>

    <div class="invoice-title">
        <h1>Invoice</h1>
    </div>

    <div class="invoice-info">
        <div class="left">
            <p><strong>Date:</strong> September 8, 2013</p>
            <p><strong>Invoice #:</strong> INV-00000</p>
            <p><strong>Customer ID:</strong> ABC12345</p>
        </div>
        <div class="right">
            <p><strong>Purchase Order #:</strong> 12345678</p>
            <p><strong>Payment Due by:</strong> October 8, 2013</p>
        </div>
    </div>

    <div class="address-section">
        <div class="bill-to">
            <h4>Bill To:</h4>
            <p>[Name]</p>
            <p>[Company Name]</p>
            <p>[Street Address]</p>
            <p>[City, ST ZIP Code]</p>
            <p>[Phone]</p>
        </div>
        <div class="ship-to">
            <h4>Ship To (If Different):</h4>
            <p>[Name]</p>
            <p>[Company Name]</p>
            <p>[Street Address]</p>
            <p>[City, ST ZIP Code]</p>
            <p>[Phone]</p>
        </div>
    </div>

    <table class="item-table">
        <thead>
        <tr>
            <th>Description</th>
            <th>Line Total</th>
        </tr>
        </thead>
        <tbody>
        <!-- Add PHP loop here to fetch and display invoice items -->
        <tr>
            <td>Printing and Binding (160*$1.75/each)</td>
            <td>$280.00</td>
        </tr>
        <tr>
            <td>A4 Printing Paper (10*$15.20/5*500 Sheets)</td>
            <td>$152.00</td>
        </tr>
        </tbody>
    </table>

    <table class="totals-section">
        <tr>
            <th>Subtotal</th>
            <td>$432.00</td>
        </tr>
        <tr>
            <th>Sales Tax Rate</th>
            <td>0%</td>
        </tr>
        <tr>
            <th>Sales Tax</th>
            <td>$0.00</td>
        </tr>
        <tr>
            <th>S&H</th>
            <td>$0.00</td>
        </tr>
        <tr>
            <th>Discount</th>
            <td>$0.00</td>
        </tr>
        <tr>
            <th>Total</th>
            <td>$432.00</td>
        </tr>
    </table>

    <div class="notes-section">
        <h5>Special Notes and Instructions</h5>
        <p>Make all checks payable to My Company Name</p>
        <p>Thank you for your business! Should you have any enquiries concerning this invoice, please contact John Doe on 0-000-000-0000</p>
    </div>

    <div class="footer-section">
        <p>111 Street, Town/City, County, ST, 00000</p>
        <p>Tel: 0-000-000-0000 Fax: 0-000-000-0000 E-mail: info@yourcompanysite.com Web: www.yourcompanysite.com</p>
    </div>

    <button onclick="window.print()" class="btn btn-primary btn-print">Print Invoice</button>
</div>
</body>
</html>
