<?php
require_once 'db_connection.php'; // Include your database connection file

// Get the record ID from the URL
$id = $_GET['id'];

// Prepare the SQL statement to fetch the record
$stmt = $conn->prepare("SELECT * FROM income_expenses WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

// Fetch the record
$record = $result->fetch_assoc();
$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Income & Expense</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <h2 class="text-center">View Income & Expense</h2>
        <div class="form-group">
            <label>Date:</label>
            <p><?= $record['date'] ?></p>
        </div>
        <div class="form-group">
            <label>Status:</label>
            <p><?= $record['status'] ?></p>
        </div>
        <div class="form-group">
            <label>Description:</label>
            <p><?= $record['description'] ?></p>
        </div>
        <div class="form-group">
            <label>Remark:</label>
            <p><?= $record['remark'] ?></p>
        </div>
        <div class="form-group">
            <label>Amount:</label>
            <p><?= $record['amount'] ?></p>
        </div>
        <a href="list_income_expenses.php" class="btn btn-secondary">Back to List</a>
    </div>
</body>
</html>
