<?php
require_once 'db_connection.php';  // Include your database connection file here

// Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Get search filters (item code, date range, document type, and summary)
$item_code_search = isset($_GET['item_code']) ? $_GET['item_code'] : '';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$document_type_search = isset($_GET['document_type']) ? $_GET['document_type'] : '';
$summary = isset($_GET['summary']) ? true : false;  // Check if summary checkbox is selected

// Base SQL query
// Base SQL query with LOWER for item_code to handle case-insensitivity
$sql = "
  SELECT * FROM (
    (SELECT 'GRN' AS document_type, grn_details.grn_no AS document_no, LOWER(grn_details.item_code) AS item_code, grn_details.item_name, grn_details.quantity, grn_master.date AS date 
     FROM grn_details 
     JOIN grn_master ON grn_details.grn_no = grn_master.grn_no)

    UNION ALL

    (SELECT 'INVOICE' AS document_type, invoice_details.invoice_no AS document_no, LOWER(invoice_details.item_id) AS item_code, invoice_details.item_name, -invoice_details.quantity AS quantity, invoice_master.invoice_date AS date 
     FROM invoice_details 
     JOIN invoice_master ON invoice_details.invoice_no = invoice_master.invoice_no)

    UNION ALL

    (SELECT 'RENT' AS document_type, rent_details.rent_no AS document_no, LOWER(rent_details.item_code) AS item_code, rent_details.item_name, -rent_details.quantity AS quantity, rent_master.date AS date 
     FROM rent_details 
     JOIN rent_master ON rent_details.rent_no = rent_master.rent_no 
     WHERE status = 'Rent')

    UNION ALL

    (SELECT 'RENT' AS document_type, rent_no AS document_no, LOWER(item_code) AS item_code, item_name, quantity AS quantity, date AS date 
     FROM rent_details 
     WHERE status = 'Return')

      UNION ALL

     (SELECT 'CUS-RET' AS document_type, customer_details.cus_rtn_id AS document_no, LOWER(customer_details.item_code) AS item_code, customer_details.item_name, customer_details.quantity, customer_return_master.date AS date 
     FROM customer_details 
     JOIN customer_return_master ON customer_details.cus_rtn_id = customer_return_master.cus_rtn_id)

    UNION ALL

     (SELECT 'WASHING' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Washing' AND `task`='In')

     UNION ALL

     (SELECT 'WASHING' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, -quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Washing' AND `task`='Out')

     UNION ALL

     (SELECT 'SHOP P' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Peradeniya Shop' AND `task`='In')

     UNION ALL

     (SELECT 'SHOP P' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, -quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Peradeniya Shop' AND `task`='Out')

     UNION ALL

     (SELECT 'DAMAGE' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, -quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Damage' AND `task`='Out')

      UNION ALL

     (SELECT 'DAMAGE' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Damage' AND `task`='In')

     UNION ALL

     (SELECT 'Other' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Other' AND `task`='In')

     UNION ALL

     (SELECT 'Other' AS document_type, `id` AS document_no, LOWER(item_code) AS item_code, item_name, -quantity AS quantity, date AS date 
     FROM item_adjustment 
     WHERE status = 'Other' AND `task`='Out')

     UNION ALL
     
     (SELECT 'ORDER' AS document_type, order_details.order_no AS document_no, LOWER(order_details.item_code) AS item_code, order_details.item_name, -order_details.quantity, order_master.date AS date 
     FROM order_details 
     JOIN order_master ON order_details.order_no = order_master.order_no)
      
  ) AS stock_data
";

// Apply filters if search parameters are provided
$conditions = [];
if ($item_code_search != '') {
    $conditions[] = "LOWER(item_code) LIKE LOWER('%" . mysqli_real_escape_string($conn, $item_code_search) . "%')";
}

if ($date_from != '' && $date_to != '') {
    $conditions[] = "date BETWEEN '$date_from' AND '$date_to'";
}

if ($document_type_search != '') {
    $conditions[] = "document_type = '" . mysqli_real_escape_string($conn, $document_type_search) . "'";
}

// If there are conditions, add them to the query
if (count($conditions) > 0) {
    $sql .= " WHERE " . implode(' AND ', $conditions);
}

// Order the result by LOWER(item_code) and date
$sql .= " ORDER BY LOWER(item_code), date";

// Execute the query
$result = mysqli_query($conn, $sql);

// Check if the query failed and display the error
if (!$result) {
    die("SQL Error: " . mysqli_error($conn));
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item Stock Report (GRN/Invoice/Rent/Return)</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .table th, .table td {
            text-align: center;
            vertical-align: middle;
        }
        .table-container {
            margin-top: 50px;
        }
        .total-row {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .search-bar {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container table-container">
        <h2 class="text-center">Item Stock Report (Bin Card)</h2>

        <!-- Search Form -->
        <form class="form-inline search-bar" method="GET">
            <div class="form-group mb-2">
                <label for="item_code" class="sr-only">Item Code</label>
                <input type="text" name="item_code" id="item_code" class="form-control" placeholder="Item Code" value="<?php echo htmlspecialchars($item_code_search); ?>">
            </div>
            <div class="form-group mx-sm-3 mb-2">
                <label for="date_from" class="sr-only">Date From</label>
                <input type="date" name="date_from" id="date_from" class="form-control" value="<?php echo htmlspecialchars($date_from); ?>">
            </div>
            <div class="form-group mx-sm-3 mb-2">
                <label for="date_to" class="sr-only">Date To</label>
                <input type="date" name="date_to" id="date_to" class="form-control" value="<?php echo htmlspecialchars($date_to); ?>">
            </div>
            <div class="form-group mx-sm-3 mb-2">
                <label for="document_type" class="sr-only">Document Type</label>
                <select name="document_type" id="document_type" class="form-control">
                    <option value="">All Document Types</option>
                    <option value="GRN" <?php if ($document_type_search == 'GRN') echo 'selected'; ?>>GRN</option>
                    <option value="INVOICE" <?php if ($document_type_search == 'INVOICE') echo 'selected'; ?>>INVOICE</option>
                    <option value="RENT" <?php if ($document_type_search == 'RENT') echo 'selected'; ?>>RENT</option>
                    <option value="CUS-RET" <?php if ($document_type_search == 'CUS-RET') echo 'selected'; ?>>CUS-RET</option>
                    <option value="WASHING" <?php if ($document_type_search == 'WASHING') echo 'selected'; ?>>WASHING</option>
                    <option value="DAMAGE" <?php if ($document_type_search == 'DAMAGE') echo 'selected'; ?>>DAMAGE</option>
                    <option value="ORDER" <?php if ($document_type_search == 'ORDER') echo 'selected'; ?>>ORDER</option>
                    
                </select>
            </div>
            <div class="form-group mx-sm-3 mb-2">
                <input type="checkbox" name="summary" id="summary" <?php if ($summary) echo 'checked'; ?>>
                <label for="summary" class="ml-2">Summary</label>
            </div>
            <button type="submit" class="btn btn-primary mb-2">Search</button>
        </form>

        <table class="table table-bordered table-striped">
            <thead class="thead-dark">
                <tr>
                    <?php if ($summary): ?>
                        <th>Item Code</th>
                        <th>Item Name</th>
                        <th>Total Quantity</th>
                    <?php else: ?>
                        <th>Document</th>
                        <th>Document No</th>
                        <th>Item Code</th>
                        <th>Item Name</th>
                        <th>Date</th>
                        <th>Item Gun (Quantity)</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php 
                // Initialize variables to store totals and the current item code for grouping
                $current_item_code = null;
                $total_item_gun = 0;
                $grand_total_item_gun = 0;

                if (mysqli_num_rows($result) > 0):
                    while ($row = mysqli_fetch_assoc($result)): 

                        // If the item code has changed, display a summary row for the item-wise total
                        if (!$summary && $current_item_code !== null && $current_item_code !== $row['item_code']): ?>
                            <tr class="total-row">
                                <td colspan="5">Total for Item <?php echo htmlspecialchars($current_item_code); ?></td>
                                <td><?php echo number_format($total_item_gun, 2); ?></td>
                            </tr>
                            <?php 
                            // Reset the total for the new item and add to grand total
                            $grand_total_item_gun += $total_item_gun;
                            $total_item_gun = 0;
                        endif;

                        // Update the current item code
                        $current_item_code = $row['item_code'];

                        // Add the quantity to the total for the current item
                        $total_item_gun += $row['quantity'];

                        if (!$summary): // Display detailed report
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['document_type']); ?></td>
                                <td><?php echo htmlspecialchars($row['document_no']); ?></td>
                                <td><?php echo htmlspecialchars($row['item_code']); ?></td>
                                <td><?php echo htmlspecialchars($row['item_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['date']); ?></td>
                                <td><?php echo number_format($row['quantity'], 2); ?></td>
                            </tr>
                        <?php
                        endif;

                    endwhile; ?>
                    
                    <!-- Display the total for the last item in the detailed report -->
                    <?php if (!$summary): ?>
                        <tr class="total-row">
                            <td colspan="5">Total for Item <?php echo htmlspecialchars($current_item_code); ?></td>
                            <td><?php echo number_format($total_item_gun, 2); ?></td>
                        </tr>
                        <!-- Add the last item's total to the grand total -->
                        <?php $grand_total_item_gun += $total_item_gun; ?>

                        <!-- Display grand total -->
                        <tr class="total-row">
                            <td colspan="5">Grand Total for All Items</td>
                            <td><?php echo number_format($grand_total_item_gun, 2); ?></td>
                        </tr>
                    <?php else: 
                        // Display the summary row for each item in the summarized report
                        mysqli_data_seek($result, 0);  // Reset result pointer
                        $summary_sql = "
                            SELECT item_code, item_name, SUM(quantity) AS total_quantity 
                            FROM ($sql) AS summary_data 
                            GROUP BY item_code, item_name
                        ";
                        $summary_result = mysqli_query($conn, $summary_sql);
                        
                        while ($summary_row = mysqli_fetch_assoc($summary_result)): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($summary_row['item_code']); ?></td>
                                <td><?php echo htmlspecialchars($summary_row['item_name']); ?></td>
                                <td><?php echo number_format($summary_row['total_quantity'], 2); ?></td>
                            </tr>
                        <?php endwhile;
                    endif;
                else: ?>
                    <tr>
                        <td colspan="<?php echo $summary ? '3' : '6'; ?>" class="text-center">No Data Available</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>

<?php
// Close the database connection
mysqli_close($conn);
