<?php
include 'db_connection.php'; // Include the database connection file

// Query to fetch records where status is 'Rent' and no corresponding 'Return' exists
$sql = "SELECT rd1.* 
        FROM rent_details rd1
        LEFT JOIN rent_details rd2 ON rd1.rent_no = rd2.rent_no AND rd2.status = 'Return'
        WHERE rd1.status = 'Rent' AND rd2.id IS NULL
        ORDER BY rd1.date DESC";

$result = $conn->query($sql);

$rentDetails = [];
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $rentDetails[] = $row;
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Not Returned Rent Details Report</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .table thead th {
            background-color: #343a40;
            color: white;
        }
        .table tbody tr:hover {
            background-color: #f1f1f1;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center mb-4">Not Returned Rent Details Report</h2>
        <table class="table table-bordered table-striped">
            <thead class="thead-dark">
                <tr>
                    <th>Rent No</th>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Status</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($rentDetails)): ?>
                    <?php foreach ($rentDetails as $detail): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($detail['rent_no']); ?></td>
                            <td><?php echo htmlspecialchars($detail['item_code']); ?></td>
                            <td><?php echo htmlspecialchars($detail['item_name']); ?></td>
                            <td><?php echo htmlspecialchars($detail['quantity']); ?></td>
                            <td><?php echo htmlspecialchars($detail['price']); ?></td>
                            <td><?php echo htmlspecialchars($detail['status']); ?></td>
                            <td><?php echo htmlspecialchars($detail['date']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center">No records found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>