<?php
require_once 'db_connection.php';

$searchQuery = "SELECT rm.rent_no, rd.item_code, rd.item_name, 
                MAX(CASE WHEN rd.status = 'Rent' THEN rd.date ELSE NULL END) AS rent_date,
                MAX(CASE WHEN rd.status = 'Return' THEN rd.date ELSE NULL END) AS return_date,
                CASE 
                    WHEN MAX(CASE WHEN rd.status = 'Return' THEN rd.date ELSE NULL END) IS NULL 
                    THEN DATEDIFF(CURDATE(), MAX(CASE WHEN rd.status = 'Rent' THEN rd.date ELSE NULL END))
                    ELSE NULL
                END AS late_days
                FROM rent_master rm
                JOIN rent_details rd ON rm.rent_no = rd.rent_no
                WHERE 1=1";

// Add search conditions
if (!empty($_GET['item_code'])) {
    $item_code = $_GET['item_code'];
    $searchQuery .= " AND rd.item_code LIKE '%$item_code%'";
}

if (!empty($_GET['start_date']) && !empty($_GET['end_date'])) {
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];
    $searchQuery .= " AND rd.date BETWEEN '$start_date' AND '$end_date'";
}

$searchQuery .= " GROUP BY rm.rent_no, rd.item_code, rd.item_name ORDER BY rent_date ASC";
$result = $conn->query($searchQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent and Return Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .late-row {
            background-color: lightcoral; /* Light red color for late rows */
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <h2 class="text-center">Rent and Return Report</h2>

    <!-- Search Bar -->
    <form method="GET" class="mb-4">
        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="item_code">Item Code</label>
                <input type="text" class="form-control" id="item_code" name="item_code" value="<?php echo isset($_GET['item_code']) ? $_GET['item_code'] : ''; ?>" placeholder="Enter Item Code">
            </div>
            <div class="form-group col-md-3">
                <label for="start_date">Start Date</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo isset($_GET['start_date']) ? $_GET['start_date'] : ''; ?>">
            </div>
            <div class="form-group col-md-3">
                <label for="end_date">End Date</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo isset($_GET['end_date']) ? $_GET['end_date'] : ''; ?>">
            </div>
            <div class="form-group col-md-2 align-self-end">
                <button type="submit" class="btn btn-primary">Search</button>
            </div>
        </div>
    </form>

    <!-- Results Table -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Rent No</th>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Rent Date</th>
                <th>Return Date / Late Days</th>
            </tr>
        </thead>
        <tbody>
        <?php
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                // If the item has been returned, display the return date; otherwise, display the late days
                if (!is_null($row['return_date'])) {
                    $return_info = $row['return_date'];
                    $rowClass = ''; // No late days
                } else {
                    $return_info = "Late by {$row['late_days']} days";
                    $rowClass = 'late-row'; // Late days, apply class for red background
                }
                
                echo "<tr class='$rowClass'>
                        <td>{$row['rent_no']}</td>
                        <td>{$row['item_code']}</td>
                        <td>{$row['item_name']}</td>
                        <td>{$row['rent_date']}</td>
                        <td>{$return_info}</td>
                    </tr>";
            }
        } else {
            echo "<tr><td colspan='5'>No records found.</td></tr>";
        }
        ?>
        </tbody>
    </table>
</div>

</body>
</html>
