<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <title>View Quotation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }
        .quotation-container {
            width: 100%;
            max-width: 8.27in; /* A4 paper width */
            padding: 20px; /* Larger padding for A4 */
            margin: auto;
            background-color: #fff;
        }
        .quotation-header {
            text-align: center;
            margin-bottom: 20px;
        }
        .quotation-header img {
            max-width: 150px; /* Increase logo size */
        }
        .quotation-title {
            text-align: center;
            margin-bottom: 20px;
        }
        .quotation-title h1 {
            font-size: 24px; /* Adjust font size */
            color: #000;
            margin: 0;
        }
        .quotation-info {
            font-size: 14px; /* Larger font for A4 */
            margin-bottom: 20px;
        }
        .quotation-info p {
            margin: 5px 0;
        }
        .item-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
            margin-bottom: 20px;
        }
        .item-table th, .item-table td {
            padding: 10px;
            border: 1px solid #000;
            text-align: left;
        }
        .totals-section {
            width: 100%;
            font-size: 14px;
            margin-bottom: 20px;
            border-collapse: collapse;
        }
        .totals-section th, .totals-section td {
            padding: 10px;
            text-align: left;
            border: 1px solid #000;
        }
        .notes-section {
            font-size: 14px;
            margin-top: 20px;
        }
        .notes-section h5 {
            font-size: 14px;
            margin-bottom: 10px;
        }
        .notes-section p {
            margin: 0;
            padding: 10px;
            border: 1px solid #000;
            text-align: center;
        }
        .footer-section {
            text-align: center;
            font-size: 14px;
            margin-top: 30px;
            color: #000;
        }
        @media print {
            body, .quotation-container {
                width: 100%;
                max-width: 8.27in;
                margin: 0;
                padding: 0;
            }
            .btn-print {
                display: none;
            }
        }
    </style>
</head>
<body>

<div class="quotation-container">
    <?php
    require_once 'db_connection.php';

    if (isset($_GET['invoice_no'])) {
        $invoice_no = $_GET['invoice_no'];

        // Fetch invoice master details (using same invoice data for quotation)
        $sql_invoice = "SELECT * FROM invoice_master WHERE invoice_no = '$invoice_no'";
        $result_invoice = $conn->query($sql_invoice);
        $invoice = $result_invoice->fetch_assoc();

        // Fetch invoice items
        $sql_items = "SELECT * FROM invoice_details WHERE invoice_no = '$invoice_no'";
        $result_items = $conn->query($sql_items);

        // Fetch invoice payment details (if needed)
        $sql_payment = "SELECT * FROM invoice_payment_details WHERE invoice_no = '$invoice_no'";
        $result_payment = $conn->query($sql_payment);
        $payment = $result_payment->fetch_assoc();
    }
    ?>

    <div class="quotation-header">
        <img src="logo.png" alt="Company Logo">
    </div>

    <div class="quotation-title">
        <hr>
        <h1>Quotation</h1> <!-- Changed title from Invoice to Quotation -->
        <hr>
    </div>

    <div class="quotation-info">
        <p><strong>Date:</strong> <?php echo $invoice['invoice_date']; ?></p>
        <p><strong>Quotation #:</strong> <?php echo $invoice['invoice_no']; ?></p> <!-- Using invoice number for quotation -->
        <p><strong>Customer Name:</strong> <?php echo $invoice['customer_name']; ?></p>
    </div>

    <table class="item-table">
        <thead>
        <tr>
            <th>Description</th>
            <th>Price</th>
            <th>Qty</th>
            <th>Total</th>
        </tr>
        </thead>
        <tbody>
        <?php while ($item = $result_items->fetch_assoc()) { ?>
            <tr>
                <td><?php echo $item['item_name']; ?></td>
                <td><?php echo number_format($item['item_price'], 2); ?></td>
                <td><?php echo number_format($item['quantity'], 0); ?></td>
                <td><?php echo number_format($item['subtotal'], 2); ?></td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <table class="totals-section">
        <tr>
            <th>Total Amount</th>
            <td><?php echo number_format($invoice['total_amount'], 2); ?></td>
        </tr>
        <?php if ($invoice['discount'] > 0) { ?>
            <tr>
                <th>Discount</th>
                <td><?php echo number_format($invoice['discount'], 2); ?></td>
            </tr>
        <?php } ?>
        <tr>
            <th>Net Amount</th>
            <td><?php echo number_format($invoice['total_amount'] - $invoice['discount'], 2); ?></td>
        </tr>
    </table>

    <div class="notes-section">
        <h5>Special Notes and Instructions</h5>
        <p><?php echo "This quotation is valid for 30 days."; ?></p>
    </div>

    <div class="footer-section">
        <p>NO 255, Colombo Road, Peradeniya</p>
        <p><i style="font-size:15px" class="fa">&#xf095;</i> &emsp14; 081 3134005 &emsp14; <i style="font-size:15px" class="fa">&#xf232;</i>  076 1499934</p>
        <p><i style="font-size:15px" class="fa">&#xf0e0;</i>&emsp14; info@janakatailors.lk&emsp14;<i style="font-size:15px" class="fa">&#xf09a;</i> &emsp14;janaka Tailors</p>
    </div>
</div>

</body>
</html>
