<?php
require_once 'db_connection.php'; // assuming this contains the $conn for MySQLi connection

// Initialize variables for search filters
$document_type = isset($_POST['document_type']) ? $_POST['document_type'] : '';
$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : '';
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : '';

// Base SQL query
$sql = "
SELECT 
    'JOB CARD' AS Document,
    jc.id AS Document_No,
    jc.date AS Date,
    jc.balance AS Pending_Amount
FROM 
    job_cards jc
WHERE 
    jc.balance > 0

UNION ALL

SELECT 
    'RENT' AS Document,
    rm.rent_no AS Document_No,
    rm.date AS Date,
    rm.balance AS Pending_Amount
FROM 
    rent_master rm
WHERE 
    rm.balance > 0
";

// Apply filters
$filters = [];
if (!empty($document_type)) {
    $filters[] = "Document = '$document_type'";
}

if (!empty($start_date) && !empty($end_date)) {
    $filters[] = "Date BETWEEN '$start_date' AND '$end_date'";
}

// If there are filters, apply them
if (count($filters) > 0) {
    // Wrap the UNION query and apply filtering to the combined result
    $sql = "SELECT * FROM ($sql) AS combined WHERE " . implode(" AND ", $filters);
}

// Execute the query
$result = $conn->query($sql);

// Check if the query returned any rows
$pendingReport = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $pendingReport[] = $row;
    }
}

// Calculate the total pending amount
$totalPending = 0;
foreach ($pendingReport as $row) {
    $totalPending += $row['Pending_Amount'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pending Amount Report</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h1 class="mb-4">Pending Amount Report</h1>

    <!-- Search Filter Form -->
    <form method="post" class="mb-4">
        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="document_type">Document Type</label>
                <select class="form-control" id="document_type" name="document_type">
                    <option value="">All</option>
                    <option value="JOB CARD" <?php if($document_type == 'JOB CARD') echo 'selected'; ?>>JOB CARD</option>
                    <option value="RENT" <?php if($document_type == 'RENT') echo 'selected'; ?>>RENT</option>
                </select>
            </div>
            <div class="form-group col-md-3">
                <label for="start_date">Start Date</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>">
            </div>
            <div class="form-group col-md-3">
                <label for="end_date">End Date</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>">
            </div>
            <div class="form-group col-md-3">
                <label>&nbsp;</label>
                <button type="submit" class="btn btn-primary btn-block">Search</button>
            </div>
        </div>
    </form>

    <!-- Report Table -->
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Document</th>
                <th>Document No</th>
                <th>Date</th>
                <th>Pending Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($pendingReport) > 0): ?>
                <?php foreach ($pendingReport as $row): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['Document']); ?></td>
                        <td><?php echo htmlspecialchars($row['Document_No']); ?></td>
                        <td><?php echo htmlspecialchars($row['Date']); ?></td>
                        <td><?php echo number_format($row['Pending_Amount'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="text-center">No pending amounts found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Total Pending Amount -->
    <div class="alert alert-info">
        <strong>Total Pending Amount: </strong> <?php echo number_format($totalPending, 2); ?>
    </div>
</div>
</body>
</html>
