<?php
require_once 'db_connection.php';

// Initialize variables
$search = '';
$date_from = '';
$date_to = '';
$whereClauses = [];

// Handle search
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['search']) && !empty($_GET['search'])) {
        $search = $_GET['search'];
        $whereClauses[] = "(order_no LIKE '%$search%' OR job_no LIKE '%$search%')";
    }

    if (isset($_GET['date_from']) && !empty($_GET['date_from'])) {
        $date_from = $_GET['date_from'];
        $whereClauses[] = "date >= '$date_from'";
    }

    if (isset($_GET['date_to']) && !empty($_GET['date_to'])) {
        $date_to = $_GET['date_to'];
        $whereClauses[] = "date <= '$date_to'";
    }
}

// Construct the query with dynamic WHERE clause
$sql = "SELECT * FROM order_master";
if (!empty($whereClauses)) {
    $sql .= " WHERE " . implode(' AND ', $whereClauses);
}
$sql .= " ORDER BY date DESC";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Order List</h2>

    <!-- Search Form -->
    <form method="GET" class="form-inline mb-4">
        <div class="form-group mr-2">
            <input type="text" class="form-control" name="search" placeholder="Search by Order No or Job No" value="<?php echo $search; ?>">
        </div>
        <div class="form-group mr-2">
            <input type="date" class="form-control" name="date_from" placeholder="Date From" value="<?php echo $date_from; ?>">
        </div>
        <div class="form-group mr-2">
            <input type="date" class="form-control" name="date_to" placeholder="Date To" value="<?php echo $date_to; ?>">
        </div>
        <button type="submit" class="btn btn-primary mr-2">Search</button>
        <a href="list_orders.php" class="btn btn-secondary">Clear</a>
    </form>

    <!-- Create Order Button -->
    <div class="text-right mb-4">
        <a href="order_form.php" class="btn btn-success">Create Order</a>
    </div>

    <!-- Orders Table -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Order No</th>
                <th>Job No</th>
                <th>Date</th>
                <th>Handover Date</th>
                <th>Person 1</th>
                <th>Person 2</th>
                <th>Person 3</th>
                <th>Remark</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['order_no']; ?></td>
                        <td><?php echo $row['job_no']; ?></td>
                        <td><?php echo $row['date']; ?></td>
                        <td><?php echo $row['handover_date']; ?></td>
                        <td><?php echo $row['person1']; ?></td>
                        <td><?php echo $row['person2']; ?></td>
                        <td><?php echo $row['person3']; ?></td>
                        <td><?php echo $row['remark']; ?></td>
                        <td>
                            <a href="view_order.php?order_no=<?php echo $row['order_no']; ?>" class="btn btn-info btn-sm">View</a>
                            <a href="edit_order.php?order_no=<?php echo $row['order_no']; ?>" class="btn btn-warning btn-sm">Edit</a>
                            <a href="delete_order.php?order_no=<?php echo $row['order_no']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this order?');">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="9" class="text-center">No orders found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

</body>
</html>

<?php
$conn->close();
