<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GRN List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        /* Dropdown styling */
        #supplierDropdown {
            position: absolute;
            z-index: 1000;
            width: 100%;
            background: white;
            border: 1px solid #ccc;
            border-radius: 4px;
            max-height: 200px;
            overflow-y: auto;
            display: none;
        }
        #supplierDropdown div {
            padding: 8px;
            cursor: pointer;
        }
        #supplierDropdown div:hover {
            background-color: #f1f1f1;
        }
        /* Hide elements in print */
        @media print {
            .print-btn, .search-bar, .actions-col, .no-print { display: none; }
            #printTitle { display: block; margin-bottom: 20px; text-align: center; font-size: 24px; font-weight: bold; }
        }
        /* Hide print title by default */
        #printTitle { display: none; }
    </style>
</head>
<body>
<div class="container mt-5">
    <div class="d-flex justify-content-between mb-3">
        <h2 class="text-center">GRN List</h2>
        <a href="create_grn.php" class="btn btn-success">Create New GRN</a>
    </div>
    
    <!-- Print Title for Report -->
    <div id="printTitle">GRN List Report</div>
    
    <!-- Search filters -->
    <div class="row mb-3 search-bar">
        <div class="col-md-6">
            <input type="text" id="searchGrnNo" class="form-control" placeholder="Search by GRN No">
        </div>
        <div class="col-md-6 position-relative">
            <input type="text" id="searchSupplier" class="form-control" placeholder="Search by Supplier Name">
            <div id="supplierDropdown"></div>
        </div>
    </div>
    
    <!-- GRN Table -->
    <table class="table table-bordered" id="grnTable">
        <thead>
            <tr>
                <th>GRN No</th>
                <th>Supplier Name</th>
                <th>Date</th>
                <th>Total</th>
                <th>Balance</th>
                <th class="actions-col">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            require_once 'db_connection.php';

            $sql = "SELECT * FROM grn_master ORDER BY grn_no DESC";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>{$row['grn_no']}</td>";
                    echo "<td>{$row['supplier_name']}</td>";
                    echo "<td>{$row['date']}</td>";
                    echo "<td>{$row['total']}</td>";
                    echo "<td>{$row['balance']}</td>";
                    echo "<td class='actions-col'>
                            <a href='edit_grn.php?grn_no={$row['grn_no']}' class='btn btn-primary'>Edit</a>
                            <a href='delete_grn.php?grn_no={$row['grn_no']}' class='btn btn-danger'>Delete</a>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='6' class='text-center'>No GRNs found</td></tr>";
            }

            $conn->close();
            ?>
        </tbody>
    </table>

    <!-- Print Button -->
    <div class="text-right mt-3">
        <button onclick="printTable()" class="btn btn-info print-btn">Print GRN List</button>
    </div>
</div>

<script>
$(document).ready(function() {
    // AJAX call to fetch supplier names
    $('#searchSupplier').on('keyup', function() {
        var query = $(this).val();
        if (query.length > 1) {  // Start searching after 2 characters
            $.ajax({
                url: 'fetch_suppliers.php',
                method: 'POST',
                data: { query: query },
                success: function(data) {
                    var suppliers = JSON.parse(data);
                    $('#supplierDropdown').empty().show();
                    suppliers.forEach(function(supplier) {
                        $('#supplierDropdown').append('<div>' + supplier + '</div>');
                    });
                }
            });
        } else {
            $('#supplierDropdown').hide();
        }
    });

    // Fill search input on dropdown click
    $(document).on('click', '#supplierDropdown div', function() {
        $('#searchSupplier').val($(this).text());
        $('#supplierDropdown').hide();
        filterTable();  // Filter table by selected supplier name
    });

    // Hide dropdown if clicked outside
    $(document).click(function(e) {
        if (!$(e.target).closest('#searchSupplier, #supplierDropdown').length) {
            $('#supplierDropdown').hide();
        }
    });

    // Filter table function
    function filterTable() {
        var grnValue = $('#searchGrnNo').val().toLowerCase();
        var supplierValue = $('#searchSupplier').val().toLowerCase();

        $('#grnTable tbody tr').filter(function() {
            var grnText = $(this).find('td:first').text().toLowerCase();
            var supplierText = $(this).find('td:nth-child(2)').text().toLowerCase();

            $(this).toggle(grnText.indexOf(grnValue) > -1 && supplierText.indexOf(supplierValue) > -1);
        });
    }

    // Event listeners for real-time table filtering
    $('#searchGrnNo').on('keyup', filterTable);
    $('#searchSupplier').on('keyup', filterTable);
});

// Print function
function printTable() {
    window.print();
}
</script>
</body>
</html>
