<?php
require_once 'db_connection.php'; // Include your database connection file

// Initialize variables for filtering
$grn_no = '';
$start_date = '';
$end_date = '';

$filter_conditions = [];
$sql_filter = "";

// Check if the form is submitted and retrieve form data
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (!empty($_GET['grn_no'])) {
        $grn_no = $_GET['grn_no'];
        $filter_conditions[] = "grn_no LIKE '%$grn_no%'";
    }
    if (!empty($_GET['start_date'])) {
        $start_date = $_GET['start_date'];
        $filter_conditions[] = "date >= '$start_date'";
    }
    if (!empty($_GET['end_date'])) {
        $end_date = $_GET['end_date'];
        $filter_conditions[] = "date <= '$end_date'";
    }

    // Combine the conditions into SQL filter string
    if (count($filter_conditions) > 0) {
        $sql_filter = "WHERE " . implode(' AND ', $filter_conditions);
    }
}

// Fetch GRN master records with the applied filters
$sql = "SELECT * FROM grn_master $sql_filter ORDER BY date DESC";
$result_master = $conn->query($sql);

?>
<!DOCTYPE html>
<html lang="en">
<style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .table th {
            background-color: #f8f9fa;
        }
        .btn {
            margin-right: 5px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                background-color: #fff;
            }
            .container {
                box-shadow: none;
            }
            .print-header {
                display: block;
                margin-bottom: 20px;
                font-weight: bold;
                font-size: 18px;
                text-align: center;
            }
        }
        .print-header {
            display: none;
        }
    </style>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GRN Listing Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">GRN Listing Report</h2>

    <!-- Search Form -->
    <form method="GET" action="grn_listing.php" class="form-inline mb-4 justify-content-center">
        <div class="form-group mr-2">
            <label for="grn_no" class="mr-2">GRN No:</label>
            <input type="text" id="grn_no" name="grn_no" class="form-control" value="<?php echo $grn_no; ?>" placeholder="Enter GRN No">
        </div>
        <div class="form-group mr-2">
            <label for="start_date" class="mr-2">Start Date:</label>
            <input type="date" id="start_date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
        </div>
        <div class="form-group mr-2">
            <label for="end_date" class="mr-2">End Date:</label>
            <input type="date" id="end_date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
        </div>
        <button type="submit" class="btn btn-primary">Search</button>
    </form>

    <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>GRN No</th>
                    <th>Supplier Name</th>
                    <th>Date</th>
                    <th>Total</th>
                    <th>Balance</th>
                    <th>Remark</th>
                    <th>Details</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result_master->num_rows > 0) {
                    while ($row_master = $result_master->fetch_assoc()) {
                        $grn_no = $row_master['grn_no'];
                        echo "<tr>
                                <td>{$row_master['grn_no']}</td>
                                <td>{$row_master['supplier_name']}</td>
                                <td>{$row_master['date']}</td>
                                <td>{$row_master['total']}</td>
                                <td>{$row_master['balance']}</td>
                                <td>{$row_master['remark']}</td>
                                <td>
                                    <button class='btn btn-primary' type='button' data-toggle='collapse' data-target='#details{$grn_no}' aria-expanded='false'>
                                        View Details
                                    </button>
                                </td>
                              </tr>";

                        // Fetch GRN details for this GRN No
                        $sql_details = "SELECT * FROM grn_details WHERE grn_no = '$grn_no'";
                        $result_details = $conn->query($sql_details);

                        if ($result_details->num_rows > 0) {
                            echo "<tr class='collapse' id='details{$grn_no}'>
                                    <td colspan='7'>
                                        <table class='table table-sm table-bordered'>
                                            <thead>
                                                <tr>
                                                    <th>Item Code</th>
                                                    <th>Item Name</th>
                                                    <th>Quantity</th>
                                                    <th>Unit Price</th>
                                                    <th>Subtotal</th>
                                                </tr>
                                            </thead>
                                            <tbody>";

                            while ($row_details = $result_details->fetch_assoc()) {
                                echo "<tr>
                                        <td>{$row_details['item_code']}</td>
                                        <td>{$row_details['item_name']}</td>
                                        <td>{$row_details['quantity']}</td>
                                        <td>{$row_details['unit_price']}</td>
                                        <td>{$row_details['sub_total']}</td>
                                      </tr>";
                            }

                            echo "      </tbody>
                                        </table>
                                    </td>
                                  </tr>";
                        }
                    }
                } else {
                    echo "<tr><td colspan='7' class='text-center'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>

<?php
$conn->close();
?>
