<?php
require_once 'db_connection.php';

// Fetch the highest GRN number from the grn_master table
$sql_grn_max = "SELECT MAX(grn_no) as max_grn_no FROM grn_master";
$result_grn_max = $conn->query($sql_grn_max);
$max_grn_no = $result_grn_max->fetch_assoc()['max_grn_no'];

if ($max_grn_no) {
    // Extract the numeric part of the highest GRN number and increment it by 1
    $max_grn_num = intval(substr($max_grn_no, -4)); // Assuming last 4 digits are the number part
    $new_grn_num = $max_grn_num + 1;
} else {
    // Start from 1 if there are no previous GRN numbers
    $new_grn_num = 1;
}

// Generate the new GRN number with leading zeros and the 'GRN-JA' prefix
$new_grn_no = 'GRN-JA' . str_pad($new_grn_num, 4, '0', STR_PAD_LEFT);

echo $new_grn_no;

$conn->close();
?>

