<?php
require_once 'db_connection.php';

// Check if order_no is provided
if (!isset($_GET['order_no'])) {
    die("Error: Order No not provided.");
}

$order_no = $_GET['order_no'];

// Fetch Order Master Data
$sql_master = "SELECT * FROM order_master WHERE order_no = ?";
$stmt_master = $conn->prepare($sql_master);
$stmt_master->bind_param("i", $order_no);
$stmt_master->execute();
$result_master = $stmt_master->get_result();
$order_master = $result_master->fetch_assoc();
$stmt_master->close();

// Fetch Order Details Data
$sql_details = "SELECT * FROM order_details WHERE order_no = ?";
$stmt_details = $conn->prepare($sql_details);
$stmt_details->bind_param("i", $order_no);
$stmt_details->execute();
$result_details = $stmt_details->get_result();
$order_details = $result_details->fetch_all(MYSQLI_ASSOC);
$stmt_details->close();

// Fetch Order Status Data
$sql_status = "SELECT * FROM order_status WHERE order_no = ?";
$stmt_status = $conn->prepare($sql_status);
$stmt_status->bind_param("i", $order_no);
$stmt_status->execute();
$result_status = $stmt_status->get_result();
$order_status = $result_status->fetch_all(MYSQLI_ASSOC);
$stmt_status->close();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Update order_master
    $job_no = $_POST['job_no'];
    $date = $_POST['date'];
    $handover_date = $_POST['handover_date'];
    $person1 = $_POST['person1'];
    $person2 = $_POST['person2'];
    $person3 = $_POST['person3'];
    $remark = $_POST['remark'];

    $sql_update_master = "UPDATE order_master SET job_no=?, date=?, handover_date=?, person1=?, person2=?, person3=?, remark=? WHERE order_no=?";
    $stmt_update_master = $conn->prepare($sql_update_master);
    $stmt_update_master->bind_param("sssssssi", $job_no, $date, $handover_date, $person1, $person2, $person3, $remark, $order_no);
    $stmt_update_master->execute();
    $stmt_update_master->close();

    // Delete existing order details and status
    $conn->query("DELETE FROM order_details WHERE order_no = $order_no");
    $conn->query("DELETE FROM order_status WHERE order_no = $order_no");

    // Insert updated order details
    foreach ($_POST['details'] as $detail) {
        $item_code = $detail['item_code'];
        $item_name = $detail['item_name'];
        $quantity = $detail['quantity'];
        $detail_remark = $detail['remark'];

        $sql_insert_details = "INSERT INTO order_details (order_no, item_code, item_name, quantity, remark) VALUES (?, ?, ?, ?, ?)";
        $stmt_insert_details = $conn->prepare($sql_insert_details);
        $stmt_insert_details->bind_param("issss", $order_no, $item_code, $item_name, $quantity, $detail_remark);
        $stmt_insert_details->execute();
        $stmt_insert_details->close();
    }

    // Insert updated order status
    foreach ($_POST['status'] as $status) {
        $status_date = $status['status_date'];
        $description = $status['description'];
        $status_value = $status['status'];

        $sql_insert_status = "INSERT INTO order_status (order_no, status_date, description, status) VALUES (?, ?, ?, ?)";
        $stmt_insert_status = $conn->prepare($sql_insert_status);
        $stmt_insert_status->bind_param("isss", $order_no, $status_date, $description, $status_value);
        $stmt_insert_status->execute();
        $stmt_insert_status->close();
    }

    // Redirect back to the list page after saving
    header("Location: list_orders.php");
    exit();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Order</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Edit Order</h2>

    <form method="POST">
        <!-- Order Master Section -->
        <div class="section-header">
            <h4>Order Master</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="job_no">Job No</label>
                <input type="text" class="form-control" id="job_no" name="job_no" value="<?php echo $order_master['job_no']; ?>" required>
            </div>
            <div class="form-group col-md-6">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" value="<?php echo $order_master['date']; ?>" required>
            </div>
            <div class="form-group col-md-6">
                <label for="handover_date">Handover Date</label>
                <input type="date" class="form-control" id="handover_date" name="handover_date" value="<?php echo $order_master['handover_date']; ?>" required>
            </div>
            <div class="form-group col-md-6">
                <label for="person1">Person 1</label>
                <select class="form-control" id="person1" name="person1">
                    <option <?php if($order_master['person1'] == 'Nalani') echo 'selected'; ?> value="Nalani">Nalani</option>
                    <option <?php if($order_master['person1'] == 'Padmini') echo 'selected'; ?> value="Padmini">Padmini</option>
                    <option <?php if($order_master['person1'] == 'Dasanayake') echo 'selected'; ?> value="Dasanayake">Dasanayake</option>
                    <option <?php if($order_master['person1'] == 'Kumari') echo 'selected'; ?> value="Kumari">Kumari</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="person2">Person 2</label>
                <select class="form-control" id="person2" name="person2">
                    <option <?php if($order_master['person2'] == 'Nalani') echo 'selected'; ?> value="Nalani">Nalani</option>
                    <option <?php if($order_master['person2'] == 'Padmini') echo 'selected'; ?> value="Padmini">Padmini</option>
                    <option <?php if($order_master['person2'] == 'Dasanayake') echo 'selected'; ?> value="Dasanayake">Dasanayake</option>
                    <option <?php if($order_master['person2'] == 'Kumari') echo 'selected'; ?> value="Kumari">Kumari</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="person3">Person 3</label>
                <select class="form-control" id="person3" name="person3">
                    <option <?php if($order_master['person3'] == 'Nalani') echo 'selected'; ?> value="Nalani">Nalani</option>
                    <option <?php if($order_master['person3'] == 'Padmini') echo 'selected'; ?> value="Padmini">Padmini</option>
                    <option <?php if($order_master['person3'] == 'Dasanayake') echo 'selected'; ?> value="Dasanayake">Dasanayake</option>
                    <option <?php if($order_master['person3'] == 'Kumari') echo 'selected'; ?> value="Kumari">Kumari</option>
                </select>
            </div>
            <div class="form-group col-md-12">
                <label for="remark">Remark</label>
                <textarea class="form-control" id="remark" name="remark"><?php echo $order_master['remark']; ?></textarea>
            </div>
        </div>

        <!-- Order Details Section -->
        <div class="section-header">
            <h4>Order Details</h4>
        </div>
        <div id="orderDetails">
            <?php foreach ($order_details as $index => $detail): ?>
                <div class="form-row mb-2 order-detail-row">
                    <div class="form-group col-md-3">
                        <label>Item Code</label>
                        <input type="text" class="form-control" name="details[<?php echo $index; ?>][item_code]" value="<?php echo $detail['item_code']; ?>" required>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Item Name</label>
                        <input type="text" class="form-control" name="details[<?php echo $index; ?>][item_name]" value="<?php echo $detail['item_name']; ?>" required>
                    </div>
                    <div class="form-group col-md-2">
                        <label>Quantity</label>
                        <input type="number" step="0.01" class="form-control" name="details[<?php echo $index; ?>][quantity]" value="<?php echo $detail['quantity']; ?>" required>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Remark</label>
                        <input type="text" class="form-control" name="details[<?php echo $index; ?>][remark]" value="<?php echo $detail['remark']; ?>">
                    </div>
                    <div class="form-group col-md-1 align-self-center">
                        <button type="button" class="btn btn-danger btn-sm remove-detail-row">&times;</button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <button type="button" id="addDetailRow" class="btn btn-info btn-sm">Add Detail</button>

        <!-- Order Status Section -->
        <div class="section-header">
            <h4>Order Status</h4>
        </div>
        <div id="orderStatus">
            <?php foreach ($order_status as $index => $status): ?>
                <div class="form-row mb-2 order-status-row">
                    <div class="form-group col-md-3">
                        <label>Status Date</label>
                        <input type="date" class="form-control" name="status[<?php echo $index; ?>][status_date]" value="<?php echo $status['status_date']; ?>" required>
                    </div>
                    <div class="form-group col-md-5">
                        <label>Description</label>
                        <input type="text" class="form-control" name="status[<?php echo $index; ?>][description]" value="<?php echo $status['description']; ?>" required>
                    </div>
                    <div class="form-group col-md-3">
                        <label>Status</label>
                        <select class="form-control" name="status[<?php echo $index; ?>][status]" required>
                            <option <?php if($status['status'] == 'pending') echo 'selected'; ?> value="pending">Pending</option>
                            <option <?php if($status['status'] == 'complete') echo 'selected'; ?> value="complete">Complete</option>
                            <option <?php if($status['status'] == 'in progress') echo 'selected'; ?> value="in progress">In Progress</option>
                        </select>
                    </div>
                    <div class="form-group col-md-1 align-self-center">
                        <button type="button" class="btn btn-danger btn-sm remove-status-row">&times;</button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <button type="button" id="addStatusRow" class="btn btn-info btn-sm">Add Status</button>

        <!-- Submit -->
        <button type="submit" class="btn btn-primary mt-3">Save Changes</button>
        <a href="list_orders.php" class="btn btn-secondary mt-3">Cancel</a>
    </form>
</div>

<!-- JavaScript to handle adding/removing rows dynamically -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
$(document).ready(function() {
    let detailIndex = <?php echo count($order_details); ?>;
    let statusIndex = <?php echo count($order_status); ?>;

    // Add new Order Detail Row
    $('#addDetailRow').on('click', function() {
        $('#orderDetails').append(`
            <div class="form-row mb-2 order-detail-row">
                <div class="form-group col-md-3">
                    <label>Item Code</label>
                    <input type="text" class="form-control" name="details[` + detailIndex + `][item_code]" required>
                </div>
                <div class="form-group col-md-3">
                    <label>Item Name</label>
                    <input type="text" class="form-control" name="details[` + detailIndex + `][item_name]" required>
                </div>
                <div class="form-group col-md-2">
                    <label>Quantity</label>
                    <input type="number" step="0.01" class="form-control" name="details[` + detailIndex + `][quantity]" required>
                </div>
                <div class="form-group col-md-3">
                    <label>Remark</label>
                    <input type="text" class="form-control" name="details[` + detailIndex + `][remark]">
                </div>
                <div class="form-group col-md-1 align-self-center">
                    <button type="button" class="btn btn-danger btn-sm remove-detail-row">&times;</button>
                </div>
            </div>
        `);
        detailIndex++;
    });

    // Add new Order Status Row
    $('#addStatusRow').on('click', function() {
        $('#orderStatus').append(`
            <div class="form-row mb-2 order-status-row">
                <div class="form-group col-md-3">
                    <label>Status Date</label>
                    <input type="date" class="form-control" name="status[` + statusIndex + `][status_date]" required>
                </div>
                <div class="form-group col-md-5">
                    <label>Description</label>
                    <input type="text" class="form-control" name="status[` + statusIndex + `][description]" required>
                </div>
                <div class="form-group col-md-3">
                    <label>Status</label>
                    <select class="form-control" name="status[` + statusIndex + `][status]" required>
                        <option value="pending">Pending</option>
                        <option value="complete">Complete</option>
                        <option value="in progress">In Progress</option>
                    </select>
                </div>
                <div class="form-group col-md-1 align-self-center">
                    <button type="button" class="btn btn-danger btn-sm remove-status-row">&times;</button>
                </div>
            </div>
        `);
        statusIndex++;
    });

    // Remove Detail Row
    $(document).on('click', '.remove-detail-row', function() {
        $(this).closest('.order-detail-row').remove();
    });

    // Remove Status Row
    $(document).on('click', '.remove-status-row', function() {
        $(this).closest('.order-status-row').remove();
    });

     
});
</script>
</body>
</html>

