<?php
// Include the database connection file
include 'db_connection.php';

// Initialize search variables
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';
$doc_no = isset($_GET['doc_no']) ? $_GET['doc_no'] : '';

// Base SQL query for RENT records
$rent_query = "
    SELECT 
        rd.rent_no AS doc_no, 
        'RENT' AS doc, 
        rm.booking_date AS date, 
        rd.item_code, 
        rd.item_name, 
        rd.quantity AS qun, 
        rm.name AS c_name
    FROM 
        rent_details rd
    JOIN 
        rent_master rm ON rd.rent_no = rm.rent_no
";

// Base SQL query for JOB records
$job_query = "
    SELECT 
        ji.job_card_id AS doc_no, 
        'JOB' AS doc, 
        jc.d_date AS date, 
        ji.item_code, 
        ji.item_name, 
        ji.quantity AS qun, 
        jc.name AS c_name
    FROM 
        job_items ji
    JOIN 
        job_cards jc ON ji.job_card_id = jc.id
";

// Add search conditions to the RENT query
$rent_conditions = [];
if (!empty($start_date)) {
    $rent_conditions[] = "rm.booking_date >= '$start_date'";
}
if (!empty($end_date)) {
    $rent_conditions[] = "rm.booking_date <= '$end_date'";
}
if (!empty($doc_no)) {
    $rent_conditions[] = "rd.rent_no = '$doc_no'";
}
if (count($rent_conditions) > 0) {
    $rent_query .= " WHERE " . implode(" AND ", $rent_conditions);
}

// Add search conditions to the JOB query
$job_conditions = [];
if (!empty($start_date)) {
    $job_conditions[] = "jc.d_date >= '$start_date'";
}
if (!empty($end_date)) {
    $job_conditions[] = "jc.d_date <= '$end_date'";
}
if (!empty($doc_no)) {
    $job_conditions[] = "ji.job_card_id = '$doc_no'";
}
if (count($job_conditions) > 0) {
    $job_query .= " WHERE " . implode(" AND ", $job_conditions);
}

// Combine both queries with UNION ALL
$sql = "($rent_query) UNION ALL ($job_query) ORDER BY doc_no ASC, date DESC";

// Debugging: Output the final SQL query
// echo "<pre>SQL Query: $sql</pre>";

// Execute the query
$result = $conn->query($sql);

// Check for errors
if (!$result) {
    die("Query failed: " . $conn->error);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Combined Report</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center mb-4">Combined Report (Rent + Job)</h2>

        <!-- Search Bar -->
        <form method="GET" action="" class="mb-4">
            <div class="row">
                <div class="col-md-3">
                    <label for="start_date">Start Date</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo $start_date; ?>">
                </div>
                <div class="col-md-3">
                    <label for="end_date">End Date</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo $end_date; ?>">
                </div>
                <div class="col-md-3">
                    <label for="doc_no">Doc No</label>
                    <input type="text" class="form-control" id="doc_no" name="doc_no" value="<?php echo $doc_no; ?>" placeholder="Enter Doc No">
                </div>
                <div class="col-md-3">
                    <label>&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100">Search</button>
                </div>
            </div>
        </form>

        <!-- Report Table -->
        <?php if ($result->num_rows > 0) : ?>
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Doc No</th>
                        <th>Doc</th>
                        <th>Date</th>
                        <th>Item Code</th>
                        <th>Item Name</th>
                        <th>Quantity</th>
                        <th>Customer Name</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()) : ?>
                        <tr>
                            <td><?php echo $row['doc_no']; ?></td>
                            <td><?php echo $row['doc']; ?></td>
                            <td><?php echo $row['date']; ?></td>
                            <td><?php echo $row['item_code']; ?></td>
                            <td><?php echo $row['item_name']; ?></td>
                            <td><?php echo $row['qun']; ?></td>
                            <td><?php echo $row['c_name']; ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else : ?>
            <p class="text-center">No records found.</p>
        <?php endif; ?>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
// Close the database connection
$conn->close();
?>