<?php
require_once 'db_connection.php';
$customers = mysqli_query($conn, "SELECT customer_id, customer_name FROM customer_profile");
 
// Error Reporting
  error_reporting(E_ALL);
  ini_set('display_errors', 1);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
   // Sanitize input data
   $salesman = mysqli_real_escape_string($conn, $_POST['salesman']);
    $name = mysqli_real_escape_string($conn, $_POST['customer']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $nic_no = mysqli_real_escape_string($conn, $_POST['nic_no']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $date = mysqli_real_escape_string($conn, $_POST['date']);
    $book_date = mysqli_real_escape_string($conn, $_POST['book_date']);
    $return_date = mysqli_real_escape_string($conn, $_POST['return_date']);
    $status = mysqli_real_escape_string($conn, $_POST['status']); // New field
    $total_amount = mysqli_real_escape_string($conn, $_POST['total_amount']);
    $discount = mysqli_real_escape_string($conn, $_POST['discount']);
    $balance = mysqli_real_escape_string($conn, $_POST['balance']);
    $hdate = mysqli_real_escape_string($conn, $_POST['h_date']);

$hdate = !empty($_POST['h_date']) ? "'" . mysqli_real_escape_string($conn, $_POST['h_date']) . "'" : "NULL";

// Insert into rent_master
$sql = "INSERT INTO rent_master (salesman, name, address, nic_no, email, date, book_date, return_date, status, total_amount, discount, balance, h_date) 
            VALUES ('$salesman', '$name', '$address', '$nic_no', '$email', '$date', '$book_date', '$return_date', '$status', '$total_amount', '$discount', '$balance', $hdate)";


if (mysqli_query($conn, $sql)) {
    $rent_no = mysqli_insert_id($conn); // Get the last inserted rent_no

    // Insert rent details
    foreach ($_POST['items'] as $item) {
        $item_code = mysqli_real_escape_string($conn, $item['item_code']);
        $item_name = mysqli_real_escape_string($conn, $item['item_name']);
        $quantity = mysqli_real_escape_string($conn, $item['quantity']);
        $price = mysqli_real_escape_string($conn, $item['price']);
        $subtotal = mysqli_real_escape_string($conn, $item['subtotal']);
        $remarks = mysqli_real_escape_string($conn, $item['remarks']);

        $sql_details = "INSERT INTO rent_details (rent_no, item_code, item_name, quantity, price, subtotal, remarks) 
                        VALUES ('$rent_no', '$item_code', '$item_name', '$quantity', '$price', '$subtotal', '$remarks')";

        mysqli_query($conn, $sql_details);
    }

    // Insert rent payments
    foreach ($_POST['payments'] as $payment) {
        $payment_date = mysqli_real_escape_string($conn, $payment['date']);
        $payment_amount = mysqli_real_escape_string($conn, $payment['payment']);
        $payment_type = mysqli_real_escape_string($conn, $payment['payment_type']);
        $remark = mysqli_real_escape_string($conn, $payment['remark']);

        $sql_payment = "INSERT INTO rent_payment (rent_no, date, payment, payment_type, remark) 
                        VALUES ('$rent_no', '$payment_date', '$payment_amount', '$payment_type', '$remark')";

        mysqli_query($conn, $sql_payment);
    }

    // Redirect to a success page or show a success message
    echo "Rent created successfully!";
} else {
    echo "Error: " . $sql . "<br>" . mysqli_error($conn);
}

mysqli_close($conn);

}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Rent</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        .form-group { margin-bottom: 15px; }
        .section-header { background-color: #f8f9fa; padding: 10px; margin-bottom: 20px; border: 1px solid #dee2e6; border-radius: 5px; }
        .table th, .table td { vertical-align: middle; }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Create Rent</h2>
    <form id="rent_form" method="POST" action="create_rent.php">
       <!-- Rent Master Section -->
<div class="section-header">
    <h4>Rent Master</h4>
</div>
<div class="form-row">
    <div class="form-group col-md-3">
        <label for="salesman">Salesman</label>
        <select class="form-control" id="salesman" name="salesman" required>
            <option value="">Select Salesman</option>
            <option value="nimal">Nimal</option>
            <option value="kamal">Kamal</option>
            <option value="pranith">Pranith</option>
        </select>
    </div>
    <div class="form-group col-md-3">
    <label for="customer">Customer</label>
    <select class="form-control" id="customer" name="customer_name" required>
        <option value="">Select Customer</option>
        <?php while ($row = mysqli_fetch_assoc($customers)) { ?>
            <option value="<?= $row['customer_name'] ?>"><?= $row['customer_name'] ?></option>
        <?php } ?>
    </select>
</div>


<div class="form-group col-md-3">
    <label for="address">Address</label>
    <input type="text" class="form-control" id="address" name="address" required readonly>
</div>
<div class="form-group col-md-3">
    <label for="nic_no">NIC No</label>
    <input type="text" class="form-control" id="nic_no" name="nic_no" required readonly>
</div>
<div class="form-group col-md-3">
    <label for="email">Email</label>
    <input type="email" class="form-control" id="email" name="email" required readonly>
</div>
<div class="form-group col-md-3">
        <label for="date">Date</label>
        <input type="date" class="form-control" id="date" name="date" required>
    </div>
    <div class="form-group col-md-3">
        <label for="book_date">Book Date</label>
        <input type="date" class="form-control" id="book_date" name="book_date" required>
    </div>
    <div class="form-group col-md-3">
        <label for="return_date">Return Date</label>
        <input type="date" class="form-control" id="return_date" name="return_date" required>
    </div>
    <div class="form-group col-md-3">
        <label for="return_date">Date of Handover</label>
        <input type="date" class="form-control" id="h_date" name="h_date" >
    </div>   
    <div class="form-group col-md-3">
    <label for="status">Status</label>
    <select class="form-control" id="status" name="status" required>
        <option value="Rent">Rent</option>
        <option value="Return">Return</option>
    </select>
</div>

</div>

        <!-- Rent Details Section -->
        <div class="section-header">
            <h4>Rent Details</h4>
        </div>
        <table class="table table-bordered" id="rent_details_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Subtotal</th>
                    <th>Remarks</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="text" name="items[0][item_code]" class="form-control item_code" required></td>
                    <td><input type="text" name="items[0][item_name]" class="form-control item_name" readonly required></td>
                    <td><input type="number" name="items[0][quantity]" class="form-control quantity" value="1" min="1" required></td>
                    <td><input type="text" name="items[0][price]" class="form-control price" readonly required></td>
                    <td><input type="text" name="items[0][subtotal]" class="form-control subtotal" readonly required></td>
                    <td><input type="text" name="items[0][remarks]" class="form-control"></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Row</button>

        <!-- Rent Payment Section -->
        <div class="section-header">
            <h4>Rent Payment</h4>
        </div>
        <table class="table table-bordered" id="rent_payment_table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="date" name="payments[0][date]" class="form-control" required></td>
                    <td><input type="text" name="payments[0][payment]" class="form-control payment" required></td>
                    <td>
                        <select name="payments[0][payment_type]" class="form-control" required>
                            <option value="cash">Cash</option>
                            <option value="Credit">Credit</option>
                            <option value="Credit Card">Credit Card</option>
                            <option value="Bank Transfer">Bank Transfer</option>
                            <option value="Cheque">Cheque</option>
                        </select>
                    </td>
                    <td><input type="text" name="payments[0][remark]" class="form-control"></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Payment Row</button>

        <!-- Summary Section -->
        <div class="form-group mt-4">
            <label for="total_amount">Total Amount</label>
            <input type="text" class="form-control" id="total_amount" name="total_amount" readonly required>
        </div>
        <div class="form-group mt-4">
            <label for="discount">Discount</label>
            <input type="number" class="form-control" id="discount" name="discount" value="0" required>
        </div>
        <div class="form-group mt-4">
            <label for="balance">Balance</label>
            <input type="text" class="form-control" id="balance" name="balance" readonly required>
        </div>

        <div class="form-group mt-4">
            <button type="submit" class="btn btn-success">Create Rent</button>
        </div>
    </form>
</div>

<script>
    $(document).ready(function () {
    var itemIndex = 1;
    var paymentIndex = 1;

    // Add new row in Rent Details
    $('#add_row').click(function () {
        var newRow = `<tr>
                        <td><input type="text" name="items[${itemIndex}][item_code]" class="form-control item_code" required></td>
                        <td><input type="text" name="items[${itemIndex}][item_name]" class="form-control item_name" readonly required></td>
                        <td><input type="number" name="items[${itemIndex}][quantity]" class="form-control quantity" value="1" min="1" required></td>
                        <td><input type="text" name="items[${itemIndex}][price]" class="form-control price" readonly required></td>
                        <td><input type="text" name="items[${itemIndex}][subtotal]" class="form-control subtotal" readonly required></td>
                        <td><input type="text" name="items[${itemIndex}][remarks]" class="form-control"></td>
                        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                    </tr>`;
        $('#rent_details_table tbody').append(newRow);
        itemIndex++;
    });

    // Add new row in Rent Payment
    $('#add_payment_row').click(function () {
        var newRow = `<tr>
                        <td><input type="date" name="payments[${paymentIndex}][date]" class="form-control" required></td>
                        <td><input type="text" name="payments[${paymentIndex}][payment]" class="form-control payment" required></td>
                        <td>
                            <select name="payments[${paymentIndex}][payment_type]" class="form-control" required>
                                <option value="cash">Cash</option>
                                <option value="Credit">Credit</option>
                                <option value="Credit Card">Credit Card</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cheque">Cheque</option>
                            </select>
                        </td>
                        <td><input type="text" name="payments[${paymentIndex}][remark]" class="form-control"></td>
                        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                    </tr>`;
        $('#rent_payment_table tbody').append(newRow);
        paymentIndex++;
        calculateBalance(); // Recalculate balance after adding a new row
    });

    // Remove row
    $(document).on('click', '.remove-row', function () {
        $(this).closest('tr').remove();
        calculateTotalAmount();
        calculateBalance();
    });

    // Autofill item name and price based on item code
    $(document).on('change', '.item_code', function () {
        var $row = $(this).closest('tr');
        var itemCode = $(this).val();

        $.ajax({
            url: 'get_item_details_rent.php',
            type: 'POST',
            data: { item_code: itemCode },
            dataType: 'json',
            success: function (data) {
                $row.find('.item_name').val(data.item_name);
                $row.find('.price').val(data.item_price);
                calculateSubtotal($row);
            }
        });
    });

    // Calculate subtotal when quantity or price changes
    $(document).on('change', '.quantity, .price', function () {
        var $row = $(this).closest('tr');
        calculateSubtotal($row);
    });

    // Calculate total amount when subtotal changes
    function calculateSubtotal($row) {
        var quantity = parseFloat($row.find('.quantity').val());
        var price = parseFloat($row.find('.price').val());
        var subtotal = quantity * price;
        $row.find('.subtotal').val(subtotal.toFixed(2));
        calculateTotalAmount();
    }

    // Calculate total amount
    function calculateTotalAmount() {
        var totalAmount = 0;
        $('.subtotal').each(function () {
            totalAmount += parseFloat($(this).val()) || 0;
        });
        $('#total_amount').val(totalAmount.toFixed(2));
        calculateBalance();
    }

    // Calculate balance when discount or payments change
    $('#discount').on('input', function () {
        calculateBalance();
    });

    $(document).on('input', '.payment', function () {
        calculateBalance();
    });

    function calculateBalance() {
        var totalAmount = parseFloat($('#total_amount').val()) || 0;
        var discount = parseFloat($('#discount').val()) || 0;
        var discountedAmount = totalAmount -discount;

        var totalPayments = 0;
        $('.payment').each(function () {
            totalPayments += parseFloat($(this).val()) || 0;
        });

        var balance = discountedAmount - totalPayments;
        $('#balance').val(balance.toFixed(2));
    }
});

$(document).ready(function () {
        // Fetch customer details when a customer is selected
        $('#customer').change(function () {
            var customerId = $(this).val();
            
            if (customerId) {
                $.ajax({
                    url: 'get_customer_details.php',
                    type: 'POST',
                    data: { customer_id: customerId },
                    dataType: 'json',
                    success: function (data) {
                        if (data.error) {
                            alert(data.error);
                        } else {
                            $('#address').val(data.customer_address);
                            $('#nic_no').val(data.nic_no);
                            $('#email').val(data.customer_email);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(xhr.responseText);
                    }
                });
            } else {
                // Reset the fields if no customer is selected
                $('#address').val('');
                $('#nic_no').val('');
                $('#email').val('');
            }
        });
    });
</script>
</body>
</html>
