<?php
require_once 'db_connection.php'; // Assuming you have a separate file for DB connection
  // Error Reporting
  error_reporting(E_ALL);
  ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Rent Master Section
    $salesman = $_POST['salesman'];
    $name = $_POST['name'];
    $date = $_POST['date'];
    $total_amount = $_POST['total_amount'];
    $discount = $_POST['discount'];
    $hand_over = $_POST['hand_over'];
    $booking_date = $_POST['booking_date'];
    $fiton_date = $_POST['fiton_date'];
    $rent_action = $_POST['rent_action'];


   

    // Get total payment from rent_payment
    $total_payment = 0;
    if (isset($_POST['payments'])) {
        foreach ($_POST['payments'] as $payment) {
            $total_payment += $payment['payment'];
        }
    }

    // Calculate balance
    $balance = $total_amount - ($discount + $total_payment);

    // Insert into rent_master
    $sql_master = "INSERT INTO rent_master 
    (salesman, name, date, hand_over, booking_date, total_amount, discount, balance, fiton_date, rent_action) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt_master = $conn->prepare($sql_master);
$stmt_master->bind_param("ssssssssss", $salesman, $name, $date, $hand_over, $booking_date, $total_amount, $discount, $balance, $fiton_date, $rent_action);


    $stmt_master->execute();
    $rent_no = $stmt_master->insert_id; // Get the inserted rent_no

    // Insert into rent_details
    foreach ($_POST['items'] as $item) {
        $item_code = $item['item_code'];
        $item_name = $item['item_name'];
        $quantity = $item['quantity'];
        $price = $item['price'];
        $status = $item['status'];
        $item_date = $item['date'];
        

        $sql_details = "INSERT INTO rent_details (rent_no, item_code, item_name, quantity, price, status, date) 
                        VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt_details = $conn->prepare($sql_details);
        $stmt_details->bind_param("issidss", $rent_no, $item_code, $item_name, $quantity, $price, $status, $item_date);
        $stmt_details->execute();
    }

    // Insert into rent_payment
    if (isset($_POST['payments'])) {
        foreach ($_POST['payments'] as $payment) {
            $payment_date = $payment['date'];
            $payment_amount = $payment['payment'];
            $payment_type = $payment['payment_type'];
            $remark = $payment['remark'];

            $sql_payment = "INSERT INTO rent_payment (rent_no, date, payment, payment_type, remark) 
                            VALUES (?, ?, ?, ?, ?)";
            $stmt_payment = $conn->prepare($sql_payment);
            $stmt_payment->bind_param("isdss", $rent_no, $payment_date, $payment_amount, $payment_type, $remark);
            $stmt_payment->execute();
        }
    }
    header("Location: list_rent.php");
    echo "Rent transaction created successfully!";
}
?>
