<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create GRN</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        .form-group {
            margin-bottom: 15px;
        }
        .table thead th {
            vertical-align: middle;
        }
        .section-header {
            background-color: #f8f9fa;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <h2 class="text-center">Create Goods Received Note (GRN)</h2>
    <form id="grn_form" method="POST">
        <!-- Master Section -->
        <div class="section-header">
            <h4>Master Section</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-2">
                <label for="grn_no">GRN No</label>
                <input type="text" class="form-control" id="grn_no" name="grn_no" readonly>
            </div>
            <div class="form-group col-md-4">
                <label for="supplier_name">Supplier Name</label>
                <select class="form-control" id="supplier_name" name="supplier_name" required>
                    <option value="">Select Supplier</option>
                    <?php
                    require_once 'db_connection.php';

                    $sql = "SELECT supplier_name FROM supplier";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<option value='" . $row['supplier_name'] . "'>" . $row['supplier_name'] . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="form-group col-md-3">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" required>
            </div>
            <div class="form-group col-md-3">
                <label for="remark">Remark</label>
                <input type="text" class="form-control" id="remark" name="remark" >
            </div>
        </div>

        <!-- Item Details Section -->
        <div class="section-header">
            <h4>Item Details Section</h4>
        </div>
        <table class="table table-bordered" id="item_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Sub Total</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="text" name="items[0][item_code]" class="form-control item_code" required></td>
                    <td><input type="text" name="items[0][item_name]" class="form-control item_name" readonly required></td>
                    <td><input type="number" step="0.01" name="items[0][quantity]" class="form-control quantity" required></td>
                    <td><input type="number" step="0.01" name="items[0][unit_price]" class="form-control unit_price"  required></td>
                    <td><input type="number" step="0.01" name="items[0][sub_total]" class="form-control sub_total" readonly required></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Row</button>

        <!-- Payment Section -->
        <div class="section-header mt-4">
            <h4>Payment Section</h4>
        </div>
        <table class="table table-bordered" id="payment_table">
            <thead>
                <tr>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Payment Date</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="number" step="0.01" name="payments[0][payment]" class="form-control payment" required></td>
                    <td>
                        <select class="form-control" name="payments[0][payment_type]" required>
                            <option value="cash">Cash</option>
                            <option value="credit">Credit</option>
                            <option value="online_transfer">Online Transfer</option>
                            <option value="credit_card">Credit Card</option>
                            <option value="check">Check</option>
                        </select>
                    </td>
                    <td><input type="date" name="payments[0][payment_date]" class="form-control payment_date" required></td>
                    <td><input type="text" name="payments[0][remark]" class="form-control payment_remark" ></td>
                    <td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Payment Row</button>

        <!-- Total and Balance Section -->
        <div class="section-header mt-4">
            <h4>Total and Balance</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="total_price">Total Price</label>
                <input type="number" step="0.01" class="form-control" id="total_price" name="total_price" readonly>
            </div>
            <div class="form-group col-md-6">
                <label for="balance">Balance</label>
                <input type="number" step="0.01" class="form-control" id="balance" name="balance" readonly>
            </div>
        </div>

        <div class="form-row mt-4">
            <div class="form-group col-md-12 text-center">
                <button type="submit" class="btn btn-success">Save GRN</button>
                <a href="list_grns.php" class="btn btn-secondary">GRN List</a>
            </div>
        </div>
    </form>

    <?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    require_once 'db_connection.php';

    // Capture the GRN number from the form input
    $grn_no = $_POST['grn_no']; // Add this line

    // Error Reporting
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    // Save GRN Master
    $date = $_POST['date'];
    $supplier_name = $_POST['supplier_name'];
    $remark = $_POST['remark'];

    $sql_master = "INSERT INTO grn_master (`grn_no`, `supplier_name`, `date`, `total`, `balance`, `remark`) VALUES ('$grn_no', '$supplier_name', '$date', 0, 0, '$remark')";

    if ($conn->query($sql_master) === TRUE) {
        // Save GRN Details
        $total_price = 0;
        foreach ($_POST['items'] as $item) {
            $item_code = $item['item_code'];
            $item_name = $item['item_name'];
            $quantity = $item['quantity'];
            $unit_price = $item['unit_price'];
            $sub_total = $item['sub_total'];
            $total_price += $sub_total;

            $sql_details = "INSERT INTO grn_details (grn_no, item_code, item_name, quantity, unit_price, sub_total) VALUES ('$grn_no', '$item_code', '$item_name', '$quantity', '$unit_price', '$sub_total')";
            $conn->query($sql_details);
        }

        // Save GRN Payment
        $total_payment = 0;
        foreach ($_POST['payments'] as $payment) {
            $payment_amount = $payment['payment'];
            $total_payment += $payment_amount;
            $payment_type = $payment['payment_type'];
            $payment_date = $payment['payment_date'];
            $payment_remark = $payment['remark'];

            $sql_payment = "INSERT INTO grn_payment (grn_no, payment, payment_type, payment_date, remark) VALUES ('$grn_no', '$payment_amount', '$payment_type', '$payment_date', '$payment_remark')";
            $conn->query($sql_payment);
        }

        // Update GRN Master with totals
        $balance = $total_price - $total_payment;
        $sql_update_master = "UPDATE grn_master SET total = '$total_price', balance = '$balance' WHERE grn_no = '$grn_no'";
        $conn->query($sql_update_master);

        echo "<div class='alert alert-success'>GRN saved successfully!</div>";
    } else {
        echo "<div class='alert alert-danger'>Error: " . $conn->error . "</div>";
    }

    $conn->close();
}
?>


</div>

<script>
$(document).ready(function() {
    var itemRowIndex = 1;
    var paymentRowIndex = 1;

    // Fetch the next GRN number and populate the GRN No field
    $.ajax({
        url: 'fetch_next_grn_no.php',
        method: 'GET',
        success: function(data) {
            $('#grn_no').val(data);
        }
    });

    $('#add_row').click(function() {
        var newRow = `<tr>
            <td><input type="text" name="items[${itemRowIndex}][item_code]" class="form-control item_code" required></td>
            <td><input type="text" name="items[${itemRowIndex}][item_name]" class="form-control item_name" readonly required></td>
            <td><input type="number" step="0.01" name="items[${itemRowIndex}][quantity]" class="form-control quantity" required></td>
            <td><input type="number" step="0.01" name="items[${itemRowIndex}][unit_price]" class="form-control unit_price"  required></td>
            <td><input type="number" step="0.01" name="items[${itemRowIndex}][sub_total]" class="form-control sub_total" readonly required></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`;
        $('#item_table tbody').append(newRow);
        itemRowIndex++;
    });

    $('#add_payment_row').click(function() {
        var newPaymentRow = `<tr>
            <td><input type="number" step="0.01" name="payments[${paymentRowIndex}][payment]" class="form-control payment" required></td>
            <td>
                <select class="form-control" name="payments[${paymentRowIndex}][payment_type]" required>
                    <option value="cash">Cash</option>
                    <option value="credit">Credit</option>
                    <option value="online_transfer">Online Transfer</option>
                    <option value="credit_card">Credit Card</option>
                    <option value="check">Check</option>
                </select>
            </td>
            <td><input type="date" name="payments[${paymentRowIndex}][payment_date]" class="form-control payment_date" required></td>
            <td><input type="text" name="payments[${paymentRowIndex}][remark]" class="form-control payment_remark" required></td>
            <td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>
        </tr>`;
        $('#payment_table tbody').append(newPaymentRow);
        paymentRowIndex++;
    });

    $(document).on('click', '.remove-row', function() {
        $(this).closest('tr').remove();
        calculateTotalPrice();
    });

    $(document).on('click', '.remove-payment-row', function() {
        $(this).closest('tr').remove();
        calculateBalance();
    });

    $(document).on('change', '.item_code', function() {
        var row = $(this).closest('tr');
        var itemCode = $(this).val();
        $.ajax({
            url: 'fetch_item_details_grn.php',
            method: 'GET',
            data: {item_code: itemCode},
            dataType: 'json',
            success: function(data) {
                row.find('.item_name').val(data.item_name);
                row.find('.unit_price').val(data.item_price);
                calculateSubTotal(row);
            }
        });
    });

    $(document).on('input', '.quantity, .unit_price', function() {
        var row = $(this).closest('tr');
        calculateSubTotal(row);
    });

    function calculateSubTotal(row) {
        var quantity = parseFloat(row.find('.quantity').val());
        var unit_price = parseFloat(row.find('.unit_price').val());
        var sub_total = quantity * unit_price;
        row.find('.sub_total').val(sub_total.toFixed(2));
        calculateTotalPrice();
    }

    function calculateTotalPrice() {
        var totalPrice = 0;
        $('.sub_total').each(function() {
            totalPrice += parseFloat($(this).val());
        });
        $('#total_price').val(totalPrice.toFixed(2));
        calculateBalance();
    }

    $(document).on('input', '.payment', function() {
        calculateBalance();
    });

    function calculateBalance() {
        var totalPrice = parseFloat($('#total_price').val()) || 0;
        var totalPayments = 0;
        $('.payment').each(function() {
            totalPayments += parseFloat($(this).val()) || 0;
        });
        var balance = totalPrice - totalPayments;
        $('#balance').val(balance.toFixed(2));
    }
});
</script>
</body>
</html>
