<?php
require_once 'db_connection.php'; // assuming this contains the $conn for MySQLi connection

// Initialize variables for search filters
$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : '';
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : '';
$in_out_filter = isset($_POST['in_out_filter']) ? $_POST['in_out_filter'] : '';

// Base SQL query with criteria `status = 'Washing'`
$sql = "
SELECT 
    'Washing' AS Document,
    id AS Document_No,
    date AS Date,
    item_code AS Item_ID,
    item_name AS Item_Name,
    CASE 
        WHEN task = 'Out' THEN -quantity
        WHEN task = '0' THEN quantity
        ELSE 0
    END AS Quantity
FROM 
    item_adjustment
WHERE 
    status = 'Washing'
";

// Apply date range filters if set
if (!empty($start_date) && !empty($end_date)) {
    $sql .= " AND date BETWEEN '$start_date' AND '$end_date'";
}

// Apply IN/OUT filter
if (!empty($in_out_filter)) {
    if ($in_out_filter === 'IN') {
        $sql .= " AND task = '0'";
    } elseif ($in_out_filter === 'OUT') {
        $sql .= " AND task = 'Out'";
    }
}

// Execute the query
$result = $conn->query($sql);

// Check if the query returned any rows
$washingReport = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $washingReport[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Washing Item In/Out Report</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h1 class="mb-4">Washing Item In/Out Report</h1>

    <!-- Search Filter Form -->
    <form method="post" class="mb-4">
        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="start_date">Start Date</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>">
            </div>
            <div class="form-group col-md-3">
                <label for="end_date">End Date</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>">
            </div>
            <div class="form-group col-md-3">
                <label for="in_out_filter">IN/OUT</label>
                <select class="form-control" id="in_out_filter" name="in_out_filter">
                    <option value="">Select IN/OUT</option>
                    <option value="IN" <?php if ($in_out_filter == 'IN') echo 'selected'; ?>>IN</option>
                    <option value="OUT" <?php if ($in_out_filter == 'OUT') echo 'selected'; ?>>OUT</option>
                </select>
            </div>
            <div class="form-group col-md-3">
                <label>&nbsp;</label>
                <button type="submit" class="btn btn-primary btn-block">Search</button>
            </div>
        </div>
    </form>

    <!-- Report Table -->
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Document</th>
                <th>Document No</th>
                <th>Date</th>
                <th>Item ID</th>
                <th>Item Name</th>
                <th>Quantity</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($washingReport) > 0): ?>
                <?php foreach ($washingReport as $row): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['Document']); ?></td>
                        <td><?php echo htmlspecialchars($row['Document_No']); ?></td>
                        <td><?php echo htmlspecialchars($row['Date']); ?></td>
                        <td><?php echo htmlspecialchars($row['Item_ID']); ?></td>
                        <td><?php echo htmlspecialchars($row['Item_Name']); ?></td>
                        <td><?php echo number_format($row['Quantity'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center">No records found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
</body>
</html>
