<?php
require_once 'db_connection.php';

if (isset($_GET['rent_no'])) {
    $rent_no = $_GET['rent_no'];

    $rent_master_query = "SELECT * FROM rent_master WHERE rent_no='$rent_no'";
    $rent_master_result = mysqli_query($conn, $rent_master_query);
    $rent_master = mysqli_fetch_assoc($rent_master_result);

    $rent_details_query = "SELECT * FROM rent_details WHERE rent_no='$rent_no'";
    $rent_details_result = mysqli_query($conn, $rent_details_query);

    $rent_payments_query = "SELECT * FROM rent_payment WHERE rent_no='$rent_no'";
    $rent_payments_result = mysqli_query($conn, $rent_payments_query);
} else {
    echo "No rent number provided!";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Rent</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .section-header { background-color: #f8f9fa; padding: 10px; margin-bottom: 20px; border: 1px solid #dee2e6; border-radius: 5px; }
        .table th, .table td { vertical-align: middle; }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">View Rent Details</h2>
    <div class="section-header">
        <h4>Rent Master</h4>
    </div>
    <table class="table table-bordered">
        <tr>
            <th>Rent Number</th>
            <td><?php echo $rent_master['rent_no']; ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <td><?php echo $rent_master['date']; ?></td>
        </tr>
        <tr>
            <th>Customer Name</th>
            <td><?php echo $rent_master['name']; ?></td>
        </tr>
        <tr>
            <th>Contact</th>
            <td><?php echo $rent_master['nic_no']; ?></td>
        </tr>
        <tr>
            <th>Address</th>
            <td><?php echo $rent_master['address']; ?></td>
        </tr>
        <tr>
            <th>Total Amount</th>
            <td><?php echo $rent_master['total_amount']; ?></td>
        </tr>
        <tr>
            <th>Discount</th>
            <td><?php echo $rent_master['discount']; ?></td>
        </tr>
        <tr>
            <th>Balance</th>
            <td><?php echo $rent_master['balance']; ?></td>
        </tr>
    </table>

    <div class="section-header">
        <h4>Rent Details</h4>
    </div>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Subtotal</th>
                <th>Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($rent_detail = mysqli_fetch_assoc($rent_details_result)) { ?>
            <tr>
                <td><?php echo $rent_detail['item_code']; ?></td>
                <td><?php echo $rent_detail['item_name']; ?></td>
                <td><?php echo $rent_detail['quantity']; ?></td>
                <td><?php echo $rent_detail['price']; ?></td>
                <td><?php echo $rent_detail['subtotal']; ?></td>
                <td><?php echo $rent_detail['remarks']; ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

    <div class="section-header">
        <h4>Rent Payment</h4>
    </div>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Date</th>
                <th>Payment</th>
                <th>Payment Type</th>
                <th>Remark</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($rent_payment = mysqli_fetch_assoc($rent_payments_result)) { ?>
            <tr>
                <td><?php echo $rent_payment['date']; ?></td>
                <td><?php echo $rent_payment['payment']; ?></td>
                <td><?php echo $rent_payment['payment_type']; ?></td>
                <td><?php echo $rent_payment['remark']; ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
</body>
</html>
