<?php
require_once 'db_connection.php';

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $sql = "SELECT * FROM job_cards WHERE id = $id";
    $result = $conn->query($sql);
    $job_card = $result->fetch_assoc();
    
    $sql_items = "SELECT * FROM job_items WHERE job_card_id = $id";
    $items_result = $conn->query($sql_items);
    
    $sql_payments = "SELECT * FROM job_payments WHERE job_card_id = $id";
    $payments_result = $conn->query($sql_payments);
} else {
    die("Job Card ID is missing.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Job Card</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">
    <h2>View Job Card</h2>
    <button class="btn btn-primary no-print" onclick="window.print()">Print</button>
    <a href="job_card_list.php" class="btn btn-secondary no-print">Back to List</a>
    <table class="table table-bordered mt-3">
        <tr>
            <th>Job ID</th>
            <td><?php echo $job_card['id']; ?></td>
        </tr>
        <tr>
            <th>Customer Name</th>
            <td><?php echo $job_card['name']; ?></td>
        </tr>
        <tr>
            <th>Address</th>
            <td><?php echo $job_card['address']; ?></td>
        </tr>
        <tr>
            <th>NIC No</th>
            <td><?php echo $job_card['nic_no']; ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <td><?php echo $job_card['date']; ?></td>
        </tr>
        <tr>
            <th>Fit-on Date</th>
            <td><?php echo $job_card['fiton_date']; ?></td>
        </tr>
        <tr>
            <th>Final Fit-on Date</th>
            <td><?php echo $job_card['final_fiton_date']; ?></td>
        </tr>
        <tr>
            <th>Total Payment</th>
            <td><?php echo $job_card['total_payment']; ?></td>
        </tr>
        <tr>
            <th>Balance</th>
            <td><?php echo $job_card['balance']; ?></td>
        </tr>
        <tr>
            <th>Job Action</th>
            <td><?php echo $job_card['job_action']; ?></td>
        </tr>
    </table>
    
    <h4>Job Items</h4>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Payment</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($item = $items_result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $item['item_code']; ?></td>
                <td><?php echo $item['item_name']; ?></td>
                <td><?php echo $item['payment']; ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

    <h4>Job Payments</h4>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Date</th>
                <th>Payment Type</th>
                <th>Payment Amount</th>
                <th>Payment By</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($payment = $payments_result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $payment['date']; ?></td>
                <td><?php echo $payment['payment_type']; ?></td>
                <td><?php echo $payment['payment_amount']; ?></td>
                <td><?php echo $payment['payment_by']; ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>
<?php $conn->close(); ?>
