<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Invoice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
            width: 100%;
            max-width: 3in; /* Set the max-width to 3 inches */
        }
        .invoice-container {
            width: 100%;
            padding: 5px; /* Reduce padding */
            background-color: #fff;
        }
        .invoice-header {
            text-align: center;
            margin-bottom: 0px;
        }
        .invoice-header img {
            max-width: 100px;
        }
        .invoice-title {
            text-align: center;
            margin-bottom: 10px;
        }
        .invoice-title h1 {
            font-size: 20px; /* Reduce font size */
            color: #000;
            margin: 0;
        }
        .invoice-info {
            font-size: 10px; /* Smaller font for information */
            margin-bottom: 10px;
        }
        .invoice-info p {
            margin: 2px 0; /* Reduce margin */
        }
        .item-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
            margin-bottom: 10px;
        }
        .item-table th, .item-table td {
            padding: 5px;
            border: 0px solid #000;
            text-align: left;
        }
        .totals-section {
            width: 100%;
            font-size: 10px;
            margin-bottom: 10px;
            border-collapse: collapse;
        }
        .totals-section th, .totals-section td {
            padding: 5px;
            text-align: left;
            border: 0px solid #000;
        }
        .notes-section {
            font-size: 10px;
            margin-top: 10px;
        }
        .notes-section h5 {
            font-size: 10px;
            margin-bottom: 5px;
        }
        .notes-section p {
            margin: 0;
            padding: 5px;
            border: 1px solid #000;
        }
        .footer-section {
            text-align: center;
            font-size: 10px;
            margin-top: 10px;
            color: #000;
        }
        @media print {
            body, .invoice-container {
                width: 100%;
                max-width: 3in;
                margin: 0;
                padding: 0;
            }
            .btn-print {
                display: none;
            }
        }
    </style>
</head>
<body>

<div class="invoice-container">
    <?php
    require_once 'db_connection.php';

    if (isset($_GET['invoice_no'])) {
        $invoice_no = $_GET['invoice_no'];

        // Fetch invoice master details
        $sql_invoice = "SELECT * FROM invoice_master WHERE invoice_no = '$invoice_no'";
        $result_invoice = $conn->query($sql_invoice);
        $invoice = $result_invoice->fetch_assoc();

        // Fetch invoice items
        $sql_items = "SELECT * FROM invoice_details WHERE invoice_no = '$invoice_no'";
        $result_items = $conn->query($sql_items);
    }
    ?>

    <div class="invoice-header">       
        <img src="logo.jpg" alt="Company Logo">       
    </div>

    <div class="invoice-title">
        <hr>
        <h1>Invoice</h1>
        <hr>
    </div>

    <div class="invoice-info">
        <p><strong>Date:</strong> <?php echo $invoice['invoice_date']; ?></p>
        <p><strong>Invoice #:</strong> <?php echo $invoice['invoice_no']; ?></p>
        <p><strong>Customer Name:</strong> <?php echo $invoice['customer_name']; ?></p>
    </div>

    <table class="item-table">
        <thead>
        <tr>
            <th>Description</th>
            <th>Price</th>
            <th>Qty</th>
            <th>Total</th>
        </tr>
        </thead>
        <tbody>
        <?php while ($item = $result_items->fetch_assoc()) { ?>
            <tr>
            <tr><td><?php echo $item['item_name']; ?></td></tr>
                <td><?php echo "" ?></td>
                <td><?php echo $item['item_price']; ?></td>
                <td><?php echo number_format($item['quantity'], 0); ?></td>
                <td><?php echo number_format($item['subtotal'], 2); ?></td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <table class="totals-section">
        <tr>
            <th>Amount</th>
            <td><?php echo number_format($invoice['total_amount'], 2); ?></td>
        </tr>
        <tr>
            <th>Discount</th>
            <td><?php echo number_format($invoice['discount'], 2); ?>%</td>
        </tr>
        <tr>
            <th>Total Amount</th>
            <td><?php echo number_format($invoice['balance'], 2); ?></td>
        </tr>
    </table>

    <div class="notes-section">
        <h5>Special Notes and Instructions</h5>
        <p><?php echo $invoice['notes']; ?></p>
    </div>

    <div class="footer-section">
        <p>NO 255, Colombo Road, Peradeniya</p>
        <p>Tel: 081 3134005 - 076 1499934</p>
        <p>Email: info@janakatailors.lk</p>
    </div>
</div>
</body>
</html>
