<?php
require_once 'db_connection.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Order</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        .form-group { margin-bottom: 15px; }
        .table thead th { vertical-align: middle; }
        .section-header { background-color: #f8f9fa; padding: 10px; margin-bottom: 20px; border: 1px solid #dee2e6; border-radius: 5px; }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Create Order</h2>
    <form id="order_form" method="POST" action="create_order.php">
        <!-- Order Master Section -->
        <div class="section-header">
            <h4>Order Master</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-4">
                <label for="job_no">Job No</label>
                <input type="text" class="form-control" id="job_no" name="job_no" required>
            </div>
            <div class="form-group col-md-4">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" required>
            </div>
            <div class="form-group col-md-4">
                <label for="handover_date">Handover Date</label>
                <input type="date" class="form-control" id="handover_date" name="handover_date" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-4">
                <label for="person1">Person 1</label>
                <select class="form-control" id="person1" name="person1" required>
                    <option value="">Select Person</option>
                    <option value="kamak">Kamak</option>
                    <option value="Nimal">Nimal</option>
                    <option value="Sapumal">Sapumal</option>
                </select>
            </div>
            <div class="form-group col-md-4">
                <label for="person2">Person 2</label>
                <select class="form-control" id="person2" name="person2" required>
                    <option value="">Select Person</option>
                    <option value="kamak">Kamak</option>
                    <option value="Nimal">Nimal</option>
                    <option value="Sapumal">Sapumal</option>
                </select>
            </div>
            <div class="form-group col-md-4">
                <label for="person3">Person 3</label>
                <select class="form-control" id="person3" name="person3" required>
                    <option value="">Select Person</option>
                    <option value="kamak">Kamak</option>
                    <option value="Nimal">Nimal</option>
                    <option value="Sapumal">Sapumal</option>
                </select>
            </div>
        </div>
        <div class="form-group">
            <label for="remark">Remark</label>
            <textarea class="form-control" id="remark" name="remark"></textarea>
        </div>

        <!-- Order Details Section -->
        <div class="section-header">
            <h4>Order Details</h4>
        </div>
        <table class="table table-bordered" id="item_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="text" name="items[0][item_code]" class="form-control item_code" required></td>
                    <td><input type="text" name="items[0][item_name]" class="form-control item_name" readonly required></td>
                    <td><input type="number" name="items[0][quantity]" class="form-control" required></td>
                    <td><input type="text" name="items[0][remark]" class="form-control"></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Row</button>

        <!-- Order Status Section -->
        <div class="section-header mt-4">
            <h4>Order Status</h4>
        </div>
        <table class="table table-bordered" id="status_table">
            <thead>
                <tr>
                    <th>Status Date</th>
                    <th>Description</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="date" name="status[0][status_date]" class="form-control" required></td>
                    <td><input type="text" name="status[0][description]" class="form-control" required></td>
                    <td>
                        <select name="status[0][status]" class="form-control" required>
                            <option value="">Select Status</option>
                            <option value="pending">Pending</option>
                            <option value="in progress">In Progress</option>
                            <option value="complete">Complete</option>
                        </select>
                    </td>
                    <td><button type="button" class="btn btn-danger remove-status-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_status_row">Add Row</button>

        <div class="form-group mt-4">
            <button type="submit" class="btn btn-success">Create Order</button>
        </div>
    </form>
</div>

<script>
    $(document).ready(function() {
        var rowIdx = 1;
        var statusRowIdx = 1;

        // Add new row in the Order Details section
        $('#add_row').on('click', function() {
            $('#item_table tbody').append(`
                <tr>
                    <td><input type="text" name="items[${rowIdx}][item_code]" class="form-control item_code" required></td>
                    <td><input type="text" name="items[${rowIdx}][item_name]" class="form-control item_name" readonly required></td>
                    <td><input type="number" name="items[${rowIdx}][quantity]" class="form-control" required></td>
                    <td><input type="text" name="items[${rowIdx}][remark]" class="form-control"></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
            `);
            rowIdx++;
        });

        // Remove row in the Order Details section
        $('#item_table').on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
        });

        // Add new row in the Order Status section
        $('#add_status_row').on('click', function() {
            $('#status_table tbody').append(`
                <tr>
                    <td><input type="date" name="status[${statusRowIdx}][status_date]" class="form-control" required></td>
                    <td><input type="text" name="status[${statusRowIdx}][description]" class="form-control" required></td>
                    <td>
                        <select name="status[${statusRowIdx}][status]" class="form-control" required>
                            <option value="">Select Status</option>
                            <option value="pending">Pending</option>
                            <option value="in progress">In Progress</option>
                            <option value="complete">Complete</option>
                        </select>
                    </td>
                    <td><button type="button" class="btn btn-danger remove-status-row">Remove</button></td>
                </tr>
            `);
            statusRowIdx++;
        });

        // Remove row in the Order Status section
        $('#status_table').on('click', '.remove-status-row', function() {
            $(this).closest('tr').remove();
        });

        // Autofill item name based on item code
        $(document).on('blur', '.item_code', function() {
            var itemCode = $(this).val();
            var row = $(this).closest('tr');
            $.ajax({
                url: 'fetch_item_name_customer.php',
                method: 'POST',
                data: { item_code: itemCode },
                success: function(data) {
                    row.find('.item_name').val(data);
                }
            });
        });
    });
</script>
</body>
</html>
