<?php
require_once 'db_connection.php';

// Search filters
$search_nic = isset($_GET['search_nic']) ? $_GET['search_nic'] : '';
$search_rent_no = isset($_GET['search_rent_no']) ? $_GET['search_rent_no'] : '';
$search_start_date = isset($_GET['search_start_date']) ? $_GET['search_start_date'] : '';
$search_end_date = isset($_GET['search_end_date']) ? $_GET['search_end_date'] : '';

$query = "SELECT * FROM rent_master WHERE 1";

if ($search_nic) {
    $query .= " AND nic_no LIKE '%" . mysqli_real_escape_string($conn, $search_nic) . "%'";
}

if ($search_rent_no) {
    $query .= " AND rent_no LIKE '%" . mysqli_real_escape_string($conn, $search_rent_no) . "%'";
}

if ($search_start_date && $search_end_date) {
    $query .= " AND date BETWEEN '" . mysqli_real_escape_string($conn, $search_start_date) . "' AND '" . mysqli_real_escape_string($conn, $search_end_date) . "'";
}

$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .search-bar { margin-bottom: 20px; }
        .btn-group { white-space: nowrap; }
        .table th, .table td { vertical-align: middle; }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Rent List</h2>
    
    <!-- Search Bar -->
    <form method="GET" action="list_rents.php" class="search-bar">
        <div class="form-row">
            <div class="form-group col-md-3">
                <input type="text" class="form-control" name="search_nic" placeholder="Search by NIC No" value="<?php echo $search_nic; ?>">
            </div>
            <div class="form-group col-md-3">
                <input type="text" class="form-control" name="search_rent_no" placeholder="Search by Rent No" value="<?php echo $search_rent_no; ?>">
            </div>
            <div class="form-group col-md-3">
                <input type="date" class="form-control" name="search_start_date" placeholder="Start Date" value="<?php echo $search_start_date; ?>">
            </div>
            <div class="form-group col-md-3">
                <input type="date" class="form-control" name="search_end_date" placeholder="End Date" value="<?php echo $search_end_date; ?>">
            </div>
        </div>
        <button type="submit" class="btn btn-primary">Search</button>
        <a href="create_rent.php" class="btn btn-success">Create Rent</a>
    </form>

    <!-- Rent List Table -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Rent No</th>
                <th>Name</th>
                <th>NIC No</th>
                <th>Date</th>
                <th>Book Date</th>
                <th>Return Date</th>
                <th>Total Amount</th>
                <th>Discount</th>
                <th>Balance</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = mysqli_fetch_assoc($result)) { ?>
            <tr>
                <td><?php echo $row['rent_no']; ?></td>
                <td><?php echo $row['name']; ?></td>
                <td><?php echo $row['nic_no']; ?></td>
                <td><?php echo $row['date']; ?></td>
                <td><?php echo $row['book_date']; ?></td>
                <td><?php echo $row['return_date']; ?></td>
                <td><?php echo $row['total_amount']; ?></td>
                <td><?php echo $row['discount']; ?></td>
                <td><?php echo $row['balance']; ?></td>
                <td>
                    <div class="btn-group">
                        <a href="view_rent.php?rent_no=<?php echo $row['rent_no']; ?>" class="btn btn-info">View</a>
                        <a href="edit_rent.php?rent_no=<?php echo $row['rent_no']; ?>" class="btn btn-warning">Edit</a>
                        <a href="delete_rent.php?rent_no=<?php echo $row['rent_no']; ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this record?');">Delete</a>
                    </div>
                </td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

    
</div>
</body>
</html>

<?php mysqli_close($conn); ?>
