<?php
require_once 'db_connection.php';

$id = $_GET['id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = $_POST['date'];
    $item_code = $_POST['item_code'];
    $item_name = $_POST['item_name'];
    $quantity = $_POST['quantity'];
    $status = $_POST['status'];
    $task = $_POST['task'];
    $remark = $_POST['remark'];

    $stmt = $conn->prepare("UPDATE item_adjustment SET date = ?, item_code = ?, item_name = ?, quantity = ?, status = ?, task = ?, remark = ? WHERE id = ?");
    $stmt->bind_param("sssisssi", $date, $item_code, $item_name, $quantity, $status, $task, $remark, $id);

    if ($stmt->execute()) {
        header("Location: list_item_adjustments.php");
        exit();
    } else {
        echo "Error updating record: " . $conn->error;
    }

    $stmt->close();
} else {
    $stmt = $conn->prepare("SELECT * FROM item_adjustment WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $item = $result->fetch_assoc();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Item Adjustment</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <h2 class="text-center mb-4">Edit Item Adjustment</h2>
        <form action="" method="POST">
            <div class="form-group">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" value="<?= $item['date'] ?>" required>
            </div>
            <div class="form-group">
                <label for="item_code">Item Code</label>
                <input type="text" class="form-control" id="item_code" name="item_code" value="<?= $item['item_code'] ?>" required onblur="fetchItemName()">
            </div>
            <div class="form-group">
                <label for="item_name">Item Name</label>
                <input type="text" class="form-control" id="item_name" name="item_name" value="<?= $item['item_name'] ?>" readonly required>
            </div>
            <div class="form-group">
                <label for="quantity">Quantity</label>
                <input type="number" step="0.01" class="form-control" id="quantity" name="quantity" value="<?= $item['quantity'] ?>" required>
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select class="form-control" id="status" name="status" required>
                    <option value="Washing" <?= $item['status'] == 'Washing' ? 'selected' : '' ?>>Washing</option>
                    <option value="Damage" <?= $item['status'] == 'Damage' ? 'selected' : '' ?>>Damage</option>
                    <option value="Other" <?= $item['status'] == 'Other' ? 'selected' : '' ?>>Other</option>
                </select>
            </div>
            <div class="form-group">
                <label for="task">Task</label>
                <select class="form-control" id="task" name="task" required>
                    <option value="In" <?= $item['task'] == 'In' ? 'selected' : '' ?>>In</option>
                    <option value="Out" <?= $item['task'] == 'Out' ? 'selected' : '' ?>>Out</option>
                </select>
            </div>
            <div class="form-group">
                <label for="remark">Remark</label>
                <textarea class="form-control" id="remark" name="remark" rows="3"><?= $item['remark'] ?></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Update Adjustment</button>
            <a href="list_item_adjustments.php" class="btn btn-secondary">Cancel</a>
        </form>
    </div>

    <script>
        function fetchItemName() {
            var itemCode = document.getElementById("item_code").value;
            if (itemCode) {
                fetch("fetch_item_ajest_name.php?item_code=" + itemCode)
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById("item_name").value = data.item_name ? data.item_name : "Item not found";
                    });
            } else {
                document.getElementById("item_name").value = '';
            }
        }
    </script>
</body>
</html>
<?php
$stmt->close();
$conn->close();
?>
