<?php
session_start();

require_once 'db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

if (isset($_GET['category_id'])) {
    $category_id = $_GET['category_id'];

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $category_name = $_POST['category_name'];

        $sql = "UPDATE category_profile SET category_name = '" . $conn->real_escape_string($category_name) . "' WHERE category_id = " . $conn->real_escape_string($category_id);
        if ($conn->query($sql) === TRUE) {
            header("Location: list_categories.php");
        } else {
            echo "Error: " . $sql . "<br>" . $conn->error;
        }
    }

    $sql = "SELECT * FROM category_profile WHERE category_id = " . $conn->real_escape_string($category_id);
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
    } else {
        echo "Category not found.";
        exit;
    }
} else {
    header("Location: list_categories.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Category</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>

    <div class="container mt-5">
        <h2>Edit Category</h2>
        <form method="POST" action="edit_category.php?category_id=<?php echo htmlspecialchars($category_id); ?>">
            <div class="form-group">
                <label for="category_name">Category Name</label>
                <input type="text" class="form-control" id="category_name" name="category_name" value="<?php echo htmlspecialchars($row['category_name']); ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Update Category</button>
        </form>
    </div>
</body>
</html>

<?php
$conn->close();
?>
